/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.apache.httpclient;

import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SentinelWrapper;
import com.alibaba.csp.sentinel.adapter.apache.httpclient.config.SentinelApacheHttpClientConfig;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.http.HttpException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.execchain.ClientExecChain;

public class SentinelApacheHttpClientBuilder
extends HttpClientBuilder {
    private final SentinelApacheHttpClientConfig config;

    public SentinelApacheHttpClientBuilder() {
        this.config = new SentinelApacheHttpClientConfig();
    }

    public SentinelApacheHttpClientBuilder(SentinelApacheHttpClientConfig config) {
        this.config = config;
    }

    protected ClientExecChain decorateMainExec(final ClientExecChain mainExec) {
        return new ClientExecChain(){

            public CloseableHttpResponse execute(final HttpRoute route, final HttpRequestWrapper request, final HttpClientContext clientContext, final HttpExecutionAware execAware) throws IOException, HttpException {
                String name = SentinelApacheHttpClientBuilder.this.config.getExtractor().extractor(request);
                if (!StringUtil.isEmpty(SentinelApacheHttpClientBuilder.this.config.getPrefix())) {
                    name = SentinelApacheHttpClientBuilder.this.config.getPrefix() + name;
                }
                try {
                    return SentinelWrapper.execute(new Callable<CloseableHttpResponse>(){

                        @Override
                        public CloseableHttpResponse call() throws Exception {
                            return mainExec.execute(route, request, clientContext, execAware);
                        }
                    }, name, EntryType.OUT, 1);
                }
                catch (BlockException e) {
                    return SentinelApacheHttpClientBuilder.this.config.getFallback().handle(request, e);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (HttpException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
    }
}

