/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.apache.httpclient.extractor;

import com.alibaba.csp.sentinel.adapter.apache.httpclient.extractor.ApacheHttpClientResourceExtractor;
import com.alibaba.csp.sentinel.log.RecordLog;
import org.apache.http.client.methods.HttpRequestWrapper;

public class DefaultApacheHttpClientResourceExtractor
implements ApacheHttpClientResourceExtractor {
    @Override
    public String extractor(HttpRequestWrapper request) {
        String httpMethod = request.getMethod();
        String originalUrl = request.getOriginal().getRequestLine().getUri();
        try {
            int firstIndexOfQuery = originalUrl.indexOf(63);
            int firstIndexOfFragment = originalUrl.indexOf(35);
            if (firstIndexOfFragment < 0 && firstIndexOfQuery < 0) {
                return httpMethod + ":" + originalUrl;
            }
            if (firstIndexOfFragment > 0 && firstIndexOfQuery > 0) {
                int pos = Math.min(firstIndexOfQuery, firstIndexOfFragment);
                return httpMethod + ":" + originalUrl.substring(0, pos);
            }
            if (firstIndexOfQuery > 0 && firstIndexOfFragment < 0) {
                return httpMethod + ":" + originalUrl.substring(0, firstIndexOfQuery);
            }
            if (firstIndexOfFragment > 0 && firstIndexOfQuery < 0) {
                return httpMethod + ":" + originalUrl.substring(0, firstIndexOfFragment);
            }
        }
        catch (Exception ex) {
            RecordLog.warn("Failed to extract resource name of HttpClient request, originalUrl={}", originalUrl, ex);
        }
        return httpMethod + ":" + originalUrl;
    }
}

