/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.dubbo;

import com.alibaba.csp.sentinel.adapter.agent.AgentCompatibilityUtils;
import com.alibaba.csp.sentinel.adapter.dubbo.DubboUtils;
import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcException;

@Activate(group={"consumer"})
public class DubboAppContextFilter
implements Filter {
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (AgentCompatibilityUtils.isAgentPresent()) {
            return invoker.invoke(invocation);
        }
        if (DubboUtils.hasDubbo27xClasses()) {
            return invoker.invoke(invocation);
        }
        String application = invoker.getUrl().getParameter("application");
        if (application != null) {
            RpcContext.getContext().setAttachment("dubboApplication", application);
        }
        return invoker.invoke(invocation);
    }
}

