/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.dubbo;

import com.alibaba.dubbo.rpc.Invocation;

public final class DubboUtils {
    public static final String DUBBO_APPLICATION_KEY = "dubboApplication";
    private static boolean dubbo27xExists = false;

    public static String getApplication(Invocation invocation, String defaultValue) {
        if (invocation == null || invocation.getAttachments() == null) {
            throw new IllegalArgumentException("Bad invocation instance");
        }
        return invocation.getAttachment(DUBBO_APPLICATION_KEY, defaultValue);
    }

    public static boolean hasDubbo27xClasses() {
        return dubbo27xExists;
    }

    private DubboUtils() {
    }

    static {
        try {
            Class.forName("org.apache.dubbo.common.extension.ExtensionLoader");
            dubbo27xExists = true;
        }
        catch (Throwable t) {
            dubbo27xExists = false;
        }
    }
}

