/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.dubbo;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.adapter.dubbo.AbstractDubboFilter;
import com.alibaba.csp.sentinel.adapter.dubbo.DubboUtils;
import com.alibaba.csp.sentinel.adapter.dubbo.config.DubboConfig;
import com.alibaba.csp.sentinel.adapter.dubbo.fallback.DubboFallbackRegistry;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcException;

@Activate(group={"consumer"})
public class SentinelDubboConsumerFilter
extends AbstractDubboFilter
implements Filter {
    public SentinelDubboConsumerFilter() {
        RecordLog.info("Sentinel Dubbo consumer filter initialized", new Object[0]);
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (DubboUtils.hasDubbo27xClasses()) {
            return invoker.invoke(invocation);
        }
        String interfaceResource = invoker.getInterface().getName();
        String methodResource = this.getResourceName(invoker, invocation, DubboConfig.getDubboConsumerPrefix());
        Entry interfaceEntry = null;
        Entry methodEntry = null;
        try {
            Object e;
            interfaceEntry = SphU.entry(interfaceResource, 2, EntryType.OUT);
            methodEntry = SphU.entry(methodResource, 2, EntryType.OUT, invocation.getArguments());
            Result result = invoker.invoke(invocation);
            if (result.hasException()) {
                e = result.getException();
                Tracer.traceEntry((Throwable)e, interfaceEntry);
                Tracer.traceEntry((Throwable)e, methodEntry);
            }
            e = result;
            return e;
        }
        catch (BlockException e) {
            String blockResource = interfaceEntry == null ? interfaceResource : methodResource;
            Result result = DubboFallbackRegistry.getConsumerFallback().handle(invoker, invocation, e, blockResource);
            return result;
        }
        catch (RpcException e) {
            Tracer.traceEntry(e, interfaceEntry);
            Tracer.traceEntry(e, methodEntry);
            throw e;
        }
        finally {
            if (methodEntry != null) {
                methodEntry.exit(1, invocation.getArguments());
            }
            if (interfaceEntry != null) {
                interfaceEntry.exit();
            }
        }
    }
}

