/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.dubbo.fallback;

import com.alibaba.csp.sentinel.adapter.dubbo.fallback.DubboFallback;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.setting.fallback.BlockFallbackConfig;
import com.alibaba.csp.sentinel.setting.fallback.BlockFallbackUtils;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.util.function.Tuple2;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcResult;

public class DefaultDubboFallback
implements DubboFallback {
    @Override
    public Result handle(Invoker<?> invoker, Invocation invocation, BlockException ex, String resourceName) {
        BlockFallbackConfig.RpcBlockFallbackBehavior b = BlockFallbackUtils.getRpcFallbackBehavior(resourceName, ex);
        if (b == null) {
            return new RpcResult((Throwable)ex.toRuntimeException());
        }
        try {
            Tuple2<Object, BlockFallbackConfig.RpcBlockFallbackBehavior> fallbackPair = BlockFallbackUtils.getRpcFallbackInstance(resourceName, ex);
            if (fallbackPair == null) {
                return new RpcResult((Throwable)ex.toRuntimeException());
            }
            if (((BlockFallbackConfig.RpcBlockFallbackBehavior)fallbackPair.r2).getRpcFallbackMode() == 0) {
                return new RpcResult(fallbackPair.r1);
            }
            return new RpcResult((Throwable)fallbackPair.r1);
        }
        catch (Throwable t) {
            RecordLog.warn("[DubboReflectCustomException] Custom rpc fallback error", t);
            return new RpcResult((Throwable)ex.toRuntimeException());
        }
    }
}

