/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.gateway.common.rule;

import com.alibaba.csp.sentinel.adapter.gateway.common.rule.GatewayFlowRule;
import com.alibaba.csp.sentinel.adapter.gateway.common.rule.GatewayParamFlowItem;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowItem;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;

final class GatewayRuleConverter {
    static FlowRule toFlowRule(GatewayFlowRule rule) {
        return new FlowRule(rule.getResource()).setControlBehavior(rule.getControlBehavior()).setCount(rule.getCount()).setGrade(rule.getGrade()).setMaxQueueingTimeMs(rule.getMaxQueueingTimeoutMs());
    }

    static ParamFlowItem generateNonMatchPassParamItem() {
        return new ParamFlowItem().setClassType(String.class.getName()).setCount(1.0E7).setObject("$NM");
    }

    static ParamFlowItem generateNonMatchBlockParamItem() {
        return new ParamFlowItem().setClassType(String.class.getName()).setCount(0.0).setObject("$NM");
    }

    static ParamFlowRule applyNonParamToParamRule(GatewayFlowRule gatewayRule, int idx) {
        return new ParamFlowRule(gatewayRule.getResource()).setCount(gatewayRule.getCount()).setGrade(gatewayRule.getGrade()).setDurationInSec(gatewayRule.getIntervalSec()).setBurstCount(gatewayRule.getBurst()).setControlBehavior(gatewayRule.getControlBehavior()).setMaxQueueingTimeMs(gatewayRule.getMaxQueueingTimeoutMs()).setParamIdx(idx);
    }

    static ParamFlowRule applyToParamRule(GatewayFlowRule gatewayRule, int idx) {
        ParamFlowRule paramRule = new ParamFlowRule(gatewayRule.getResource()).setCount(gatewayRule.getCount()).setGrade(gatewayRule.getGrade()).setDurationInSec(gatewayRule.getIntervalSec()).setBurstCount(gatewayRule.getBurst()).setControlBehavior(gatewayRule.getControlBehavior()).setMaxQueueingTimeMs(gatewayRule.getMaxQueueingTimeoutMs()).setParamIdx(idx);
        GatewayParamFlowItem gatewayItem = gatewayRule.getParamItem();
        gatewayItem.setIndex(idx);
        String valuePattern = gatewayItem.getPattern();
        if (valuePattern != null) {
            paramRule.getParamFlowItemList().add(GatewayRuleConverter.generateNonMatchPassParamItem());
        }
        return paramRule;
    }

    private GatewayRuleConverter() {
    }
}

