/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.grpc;

import com.alibaba.csp.sentinel.AsyncEntry;
import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import io.grpc.ForwardingServerCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.concurrent.atomic.AtomicReference;

public class SentinelGrpcServerInterceptor
implements ServerInterceptor {
    private static final Status FLOW_CONTROL_BLOCK = Status.UNAVAILABLE.withDescription("Flow control limit exceeded (server side)");
    private static final StatusRuntimeException STATUS_RUNTIME_EXCEPTION = new StatusRuntimeException(Status.CANCELLED);

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        String fullMethodName = call.getMethodDescriptor().getFullMethodName();
        AsyncEntry entry = null;
        try {
            entry = SphU.asyncEntry(fullMethodName, 2, EntryType.IN);
            final AtomicReference<AsyncEntry> atomicReferenceEntry = new AtomicReference<AsyncEntry>(entry);
            return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(next.startCall((ServerCall)new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

                public void close(Status status, Metadata trailers) {
                    Entry entry = (Entry)atomicReferenceEntry.get();
                    if (entry != null) {
                        if (!status.isOk()) {
                            Tracer.traceEntry((Throwable)status.asRuntimeException(), entry);
                        }
                        entry.exit();
                    }
                    super.close(status, trailers);
                }
            }, headers)){

                public void onCancel() {
                    Entry entry = (Entry)atomicReferenceEntry.get();
                    if (entry != null) {
                        Tracer.traceEntry((Throwable)STATUS_RUNTIME_EXCEPTION, entry);
                        entry.exit();
                        atomicReferenceEntry.set(null);
                    }
                    super.onCancel();
                }
            };
        }
        catch (BlockException e) {
            call.close(FLOW_CONTROL_BLOCK, new Metadata());
            return new ServerCall.Listener<ReqT>(){};
        }
        catch (RuntimeException e) {
            if (entry != null) {
                Tracer.traceEntry(e, entry);
                entry.exit();
            }
            throw e;
        }
    }
}

