/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.hsf;

import com.taobao.hsf.domain.HSFRequest;
import com.taobao.hsf.invocation.Invocation;

class HsfResourceNameUtil {
    HsfResourceNameUtil() {
    }

    public static String getResourceName(Invocation invocation) {
        StringBuilder buf = new StringBuilder(64);
        String interfaceName = HsfResourceNameUtil.getInterfaceName(invocation);
        buf.append(interfaceName).append(":").append(invocation.getMethodName()).append("(");
        boolean isFirst = true;
        for (String argSig : invocation.getMethodArgSigs()) {
            if (!isFirst) {
                buf.append(",");
            }
            buf.append(argSig);
            isFirst = false;
        }
        buf.append(")");
        return buf.toString();
    }

    public static String getInterfaceName(Invocation invocation) {
        HSFRequest request = invocation.getHsfRequest();
        String uniqueName = request.getTargetServiceUniqueName();
        if (uniqueName == null) {
            return "";
        }
        int idx = uniqueName.indexOf(":");
        if (idx == -1) {
            return uniqueName;
        }
        return uniqueName.substring(0, idx);
    }
}

