/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.hsf;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.adapter.hsf.HsfResourceNameUtil;
import com.alibaba.csp.sentinel.adapter.hsf.fallback.FallbackUtils;
import com.alibaba.csp.sentinel.adapter.hsf.fallback.HsfFallbackRegistry;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.mesh.AliMeshSentinelStatusManager;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.taobao.csp.sentinel.ResourceHookManager;
import com.taobao.csp.sentinel.hook.HsfHookTarget;
import com.taobao.hsf.annotation.Tag;
import com.taobao.hsf.domain.HSFResponse;
import com.taobao.hsf.invocation.Invocation;
import com.taobao.hsf.invocation.RPCResult;
import com.taobao.hsf.invocation.SyncInvocationHandler;
import com.taobao.hsf.invocation.SyncInvocationHandlerInterceptor;

@Tag(value={"client"})
public class SentinelHsfConsumerInterceptor
implements SyncInvocationHandlerInterceptor {
    private SyncInvocationHandler next;

    public SentinelHsfConsumerInterceptor() {
        RecordLog.info("Add SentinelHsfConsumerInterceptor to HSF Consumer handler chain", new Object[0]);
    }

    public void setSyncInvocationHandler(SyncInvocationHandler syncInvocationHandler) {
        this.next = syncInvocationHandler;
    }

    public RPCResult invoke(Invocation invocation) throws Throwable {
        if (AliMeshSentinelStatusManager.isMeshSentinelEnabled()) {
            return this.next.invoke(invocation);
        }
        String resourceName = HsfResourceNameUtil.getResourceName(invocation);
        String interfaceName = HsfResourceNameUtil.getInterfaceName(invocation);
        Entry interfaceEntry = null;
        Entry methodEntry = null;
        try {
            interfaceEntry = SphU.entry(interfaceName, 2, EntryType.OUT);
            methodEntry = SphU.entry(resourceName, 2, EntryType.OUT);
            if (ResourceHookManager.getHsfResourceHook().needHock(resourceName, "HSF_C")) {
                RPCResult rPCResult = this.handleLegacyHook(invocation, resourceName);
                return rPCResult;
            }
            RPCResult rPCResult = this.next.invoke(invocation);
            return rPCResult;
        }
        catch (BlockException e) {
            String blockResource = interfaceEntry == null ? interfaceName : resourceName;
            HSFResponse hsfResponse = FallbackUtils.handleFallback(invocation, HsfFallbackRegistry.getConsumerFallback(), e, blockResource);
            RPCResult rpcResult = new RPCResult();
            rpcResult.setHsfResponse(hsfResponse);
            RPCResult rPCResult = rpcResult;
            return rPCResult;
        }
        catch (Throwable t) {
            Tracer.traceEntry(t, interfaceEntry);
            Tracer.traceEntry(t, methodEntry);
            throw t;
        }
        finally {
            if (methodEntry != null) {
                methodEntry.exit();
            }
            if (interfaceEntry != null) {
                interfaceEntry.exit();
            }
        }
    }

    private RPCResult handleLegacyHook(final Invocation invocation, String resourceName) throws Throwable {
        HSFResponse resp;
        Object result = ResourceHookManager.getHsfResourceHook().doHook(new HsfHookTarget("HSF_C", resourceName, invocation, invocation.getMethodArgs()){

            @Override
            public Object call() throws Throwable {
                return SentinelHsfConsumerInterceptor.this.next.invoke(invocation);
            }
        });
        if (result instanceof RPCResult) {
            return (RPCResult)result;
        }
        if (result instanceof HSFResponse) {
            resp = (HSFResponse)result;
        } else {
            resp = new HSFResponse();
            resp.setAppResponse(result);
        }
        RPCResult rpcResult = new RPCResult();
        rpcResult.setHsfResponse(resp);
        return rpcResult;
    }
}

