/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.hsf;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.adapter.hsf.HsfCallbackManager;
import com.alibaba.csp.sentinel.adapter.hsf.HsfResourceNameUtil;
import com.alibaba.csp.sentinel.adapter.hsf.SentinelHsfAdapterConfig;
import com.alibaba.csp.sentinel.adapter.hsf.fallback.FallbackUtils;
import com.alibaba.csp.sentinel.adapter.hsf.fallback.HsfFallbackRegistry;
import com.alibaba.csp.sentinel.context.ContextUtil;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.mesh.AliMeshSentinelStatusManager;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.util.HostNameUtil;
import com.taobao.csp.sentinel.ResourceHookManager;
import com.taobao.csp.sentinel.hook.HsfHookTarget;
import com.taobao.hsf.annotation.Tag;
import com.taobao.hsf.domain.HSFResponse;
import com.taobao.hsf.invocation.AbstractInvocationHandlerInterceptor;
import com.taobao.hsf.invocation.Invocation;
import com.taobao.hsf.invocation.RPCResult;
import com.taobao.hsf.model.ApplicationModel;
import com.taobao.hsf.util.concurrent.DefaultListenableFuture;
import com.taobao.hsf.util.concurrent.Futures;
import com.taobao.hsf.util.concurrent.ListenableFuture;
import java.util.Objects;

@Tag(value={"server"})
public class SentinelHsfProviderInterceptor
extends AbstractInvocationHandlerInterceptor {
    public SentinelHsfProviderInterceptor() {
        RecordLog.info("Add SentinelHsfProviderInterceptor to HSF Provider handler chain", new Object[0]);
    }

    private boolean isLocalInvocation(Invocation invocation) {
        String peerIp = invocation.getPeerIP();
        String localIp = HostNameUtil.getIp();
        String consumerApp = (String)invocation.getRequestProp("Consumer-AppName");
        String currentApp = null;
        ApplicationModel hsfApp = invocation.getApplicationModel();
        if (hsfApp != null) {
            currentApp = hsfApp.getName();
        }
        return Objects.equals(peerIp, localIp) && Objects.equals(consumerApp, currentApp);
    }

    public ListenableFuture<RPCResult> invoke(Invocation invocation) throws Throwable {
        if (AliMeshSentinelStatusManager.isMeshSentinelEnabled()) {
            return this.delegate.invoke(invocation);
        }
        if (!SentinelHsfAdapterConfig.isEnableForLocalCalls() && this.isLocalInvocation(invocation)) {
            return this.delegate.invoke(invocation);
        }
        String resourceName = HsfResourceNameUtil.getResourceName(invocation);
        String interfaceName = HsfResourceNameUtil.getInterfaceName(invocation);
        String clientAppName = HsfCallbackManager.getOriginParser().parseOrigin(invocation);
        if (clientAppName == null) {
            clientAppName = "";
        }
        Entry interfaceEntry = null;
        Entry methodEntry = null;
        try {
            ContextUtil.enter(resourceName, clientAppName);
            interfaceEntry = SphU.entry(interfaceName, 2, EntryType.OUT);
            methodEntry = SphU.entry(resourceName, 2, EntryType.IN, invocation.getMethodArgs());
            if (ResourceHookManager.getHsfResourceHook().needHock(resourceName, "HSF_S")) {
                ListenableFuture<RPCResult> listenableFuture = this.handleLegacyHook(invocation, resourceName);
                return listenableFuture;
            }
            ListenableFuture listenableFuture = this.delegate.invoke(invocation);
            return listenableFuture;
        }
        catch (BlockException e) {
            String blockResource = interfaceEntry == null ? interfaceName : resourceName;
            HSFResponse hsfResponse = FallbackUtils.handleFallback(invocation, HsfFallbackRegistry.getProviderFallback(), e, blockResource);
            RPCResult rpcResult = new RPCResult();
            rpcResult.setHsfResponse(hsfResponse);
            DefaultListenableFuture future = Futures.createSettableFuture();
            future.set((Object)rpcResult);
            DefaultListenableFuture defaultListenableFuture = future;
            return defaultListenableFuture;
        }
        catch (Throwable t) {
            Tracer.traceEntry(t, interfaceEntry);
            Tracer.traceEntry(t, methodEntry);
            throw t;
        }
        finally {
            if (methodEntry != null) {
                methodEntry.exit(1, invocation.getMethodArgs());
            }
            if (interfaceEntry != null) {
                interfaceEntry.exit();
            }
            ContextUtil.exit();
        }
    }

    private ListenableFuture<RPCResult> handleLegacyHook(final Invocation invocation, String resourceName) throws Throwable {
        HSFResponse resp;
        Object result = ResourceHookManager.getHsfResourceHook().doHook(new HsfHookTarget("HSF_S", resourceName, invocation, invocation.getMethodArgs()){

            @Override
            public Object call() throws Throwable {
                return SentinelHsfProviderInterceptor.this.delegate.invoke(invocation);
            }
        });
        if (result instanceof ListenableFuture) {
            return (ListenableFuture)result;
        }
        if (result instanceof HSFResponse) {
            resp = (HSFResponse)result;
        } else {
            resp = new HSFResponse();
            resp.setAppResponse(result);
        }
        RPCResult rpcResult = new RPCResult();
        rpcResult.setHsfResponse(resp);
        DefaultListenableFuture future = Futures.createSettableFuture();
        future.set((Object)rpcResult);
        return future;
    }
}

