/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.hsf.fallback;

import com.alibaba.csp.sentinel.adapter.hsf.fallback.HsfFallback;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.setting.fallback.BlockFallbackConfig;
import com.alibaba.csp.sentinel.setting.fallback.BlockFallbackUtils;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.util.function.Tuple2;
import com.taobao.hsf.domain.HSFResponse;
import com.taobao.hsf.invocation.Invocation;

public class FallbackUtils {
    public static HSFResponse handleFallback(Invocation invocation, HsfFallback fallback, BlockException e, String resourceName) {
        BlockFallbackConfig.RpcBlockFallbackBehavior b = BlockFallbackUtils.getRpcFallbackBehavior(resourceName, e);
        if (b == null) {
            return FallbackUtils.handleDefaultFallback(invocation, fallback, e);
        }
        try {
            Tuple2<Object, BlockFallbackConfig.RpcBlockFallbackBehavior> fallbackPair = BlockFallbackUtils.getRpcFallbackInstance(resourceName, e);
            if (fallbackPair == null) {
                return FallbackUtils.handleDefaultFallback(invocation, fallback, e);
            }
            if (((BlockFallbackConfig.RpcBlockFallbackBehavior)fallbackPair.r2).getRpcFallbackMode() == 0) {
                HSFResponse hsfResponse = new HSFResponse();
                hsfResponse.setAppResponse(fallbackPair.r1);
                return hsfResponse;
            }
            HSFResponse hsfResponse = new HSFResponse();
            hsfResponse.setAppResponse(fallbackPair.r1);
            hsfResponse.setErrorType("SentinelBlockException: " + fallbackPair.r1.getClass().getSimpleName());
            return hsfResponse;
        }
        catch (Throwable t) {
            RecordLog.warn("[HsfReflectCustomException] Custom rpc fallback error", t);
            throw BlockException.THROW_OUT_EXCEPTION;
        }
    }

    private static HSFResponse handleDefaultFallback(Invocation invocation, HsfFallback fallback, BlockException e) {
        try {
            Object fallbackResult = fallback.blocked(invocation, e);
            if (fallbackResult instanceof HSFResponse) {
                return (HSFResponse)fallbackResult;
            }
            HSFResponse hsfResponse = new HSFResponse();
            hsfResponse.setAppResponse(fallbackResult);
            if (fallbackResult instanceof Exception) {
                hsfResponse.setErrorType(fallbackResult.getClass().getSimpleName());
            }
            return hsfResponse;
        }
        catch (Exception e2) {
            HSFResponse hsfResponse = new HSFResponse();
            hsfResponse.setAppResponse((Object)e2);
            if (e2 == BlockException.THROW_OUT_EXCEPTION) {
                hsfResponse.setErrorType(BlockException.THROW_OUT_EXCEPTION.getMessage());
            } else {
                hsfResponse.setErrorType(e2.getClass().getSimpleName());
            }
            return hsfResponse;
        }
    }

    private FallbackUtils() {
    }
}

