/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.okhttp;

import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SentinelWrapper;
import com.alibaba.csp.sentinel.adapter.okhttp.SentinelOkHttpConfig;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.io.IOException;
import java.util.concurrent.Callable;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class SentinelOkHttpInterceptor
implements Interceptor {
    private final SentinelOkHttpConfig config;

    public SentinelOkHttpInterceptor() {
        this.config = new SentinelOkHttpConfig();
    }

    public SentinelOkHttpInterceptor(SentinelOkHttpConfig config) {
        AssertUtil.notNull(config, "config cannot be null");
        this.config = config;
    }

    public Response intercept(final Interceptor.Chain chain) throws IOException {
        final Request request = chain.request();
        String name = this.config.getResourceExtractor().extract(request, chain.connection());
        if (StringUtil.isNotBlank(this.config.getResourcePrefix())) {
            name = this.config.getResourcePrefix() + name;
        }
        try {
            return SentinelWrapper.execute(new Callable<Response>(){

                @Override
                public Response call() throws Exception {
                    return chain.proceed(request);
                }
            }, name, EntryType.OUT, 1);
        }
        catch (BlockException e) {
            return this.config.getFallback().handle(chain.request(), chain.connection(), e);
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

