/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.proxy.entrypoint;

import com.alibaba.csp.sentinel.adapter.proxy.entrypoint.ProxyTargetClassStrategy;
import com.alibaba.csp.sentinel.adapter.proxy.entrypoint.ProxyTypeHolder;
import com.alibaba.csp.sentinel.log.RecordLog;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.autoproxy.AbstractAutoProxyCreator;
import org.springframework.beans.BeansException;
import org.springframework.core.PriorityOrdered;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class BeanTypeAutoProxyCreator
extends AbstractAutoProxyCreator
implements PriorityOrdered {
    private static final Set<String> innerProxiedBeans = Collections.synchronizedSet(new HashSet());
    private ProxyTypeHolder proxyTypeHolder;
    private String proxyTargetClassStrategy = ProxyTargetClassStrategy.DEFAULT.name();

    public void setProxyTargetClassStrategy(String proxyTargetClassStrategy) {
        this.proxyTargetClassStrategy = proxyTargetClassStrategy;
    }

    public void setProxyTypeHolder(ProxyTypeHolder proxyTypeHolder) {
        this.proxyTypeHolder = proxyTypeHolder;
    }

    protected Object wrapIfNecessary(Object bean, String beanName, Object cacheKey) {
        if (Proxy.isProxyClass(bean.getClass()) || ClassUtils.isCglibProxyClass(bean.getClass())) {
            return bean;
        }
        return super.wrapIfNecessary(bean, beanName, cacheKey);
    }

    protected Object[] getAdvicesAndAdvisorsForBean(Class beanClass, String beanName, TargetSource customTargetSource) throws BeansException {
        if (null != this.proxyTypeHolder && !CollectionUtils.isEmpty(this.proxyTypeHolder.getProxyTypes())) {
            Iterator<Class<?>> it = this.proxyTypeHolder.getProxyTypes().iterator();
            while (it.hasNext()) {
                try {
                    Class<?> mappedClass = it.next();
                    if (!this.isMatch(beanClass, mappedClass)) continue;
                    this.initProxyTargetClass(beanClass);
                    RecordLog.info("[BeanTypeAutoProxyCreator] Bean named {} of {} is proxied", beanName, beanClass.getName());
                    innerProxiedBeans.add(beanName);
                    return PROXY_WITHOUT_ADDITIONAL_INTERCEPTORS;
                }
                catch (Exception e) {
                    RecordLog.error("Failed when getAdvicesAndAdvisorsForBean", e);
                }
            }
        }
        return DO_NOT_PROXY;
    }

    private void initProxyTargetClass(Class<?> beanClass) {
        if (ProxyTargetClassStrategy.DEFAULT.name().equalsIgnoreCase(this.proxyTargetClassStrategy)) {
            if (this.targetBeanIsFinal(beanClass)) {
                this.setProxyTargetClass(false);
            } else {
                this.setProxyTargetClass(true);
            }
        } else if (ProxyTargetClassStrategy.PROXY.name().equalsIgnoreCase(this.proxyTargetClassStrategy)) {
            this.setProxyTargetClass(false);
        } else if (ProxyTargetClassStrategy.CGLIB.name().equalsIgnoreCase(this.proxyTargetClassStrategy)) {
            this.setProxyTargetClass(true);
        }
    }

    protected boolean isMatch(Class<?> beanClass, Class<?> mappedClass) {
        return null != beanClass && null != mappedClass && mappedClass.isAssignableFrom(beanClass);
    }

    private boolean targetBeanIsFinal(Class clazz) {
        String inMods = Modifier.toString(clazz.getModifiers());
        return inMods.contains("final");
    }
}

