/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.proxy.entrypoint;

import com.alibaba.csp.sentinel.log.RecordLog;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.CollectionUtils;

public class ProxyTypeHolder
implements InitializingBean {
    private List<String> beanTypes;
    private List<Class<?>> proxyTypes = new ArrayList();

    public List<Class<?>> getProxyTypes() {
        return this.proxyTypes;
    }

    public void setBeanTypes(List<String> beanTypes) {
        this.beanTypes = beanTypes;
    }

    public void afterPropertiesSet() throws Exception {
        if (CollectionUtils.isEmpty(this.beanTypes)) {
            RecordLog.info("[ProxyTypeHolder] beanTypes empty", new Object[0]);
            return;
        }
        for (String beanType : this.beanTypes) {
            try {
                this.proxyTypes.add(Class.forName(beanType));
            }
            catch (Throwable e) {
                RecordLog.warn("[ProxyTypeHolder] Class named " + beanType + " is not found, so no bean of this type will be proxied.", new Object[0]);
            }
        }
        RecordLog.info("[ProxyTypeHolder] proxyTypes: " + this.proxyTypes, new Object[0]);
    }
}

