/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.proxy.entrypoint.entrance;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.adapter.proxy.annotation.ClassTrace;
import com.alibaba.csp.sentinel.adapter.proxy.annotation.MethodTrace;
import com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import com.taobao.csp.sentinel.ResourceHookManager;
import com.taobao.csp.sentinel.hook.HookTarget;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class JavaEntranceInterceptor
implements MethodInterceptor {
    public Object invoke(final MethodInvocation invocation) throws Throwable {
        Method executed = invocation.getMethod();
        Class<?> classType = invocation.getThis().getClass();
        ClassTrace classTrace = classType.getAnnotation(ClassTrace.class);
        MethodTrace methodTrace = executed.getAnnotation(MethodTrace.class);
        if ("toString".equals(executed.getName()) || "hashCode".equals(executed.getName()) || "equals".equals(executed.getName()) || null != classTrace && !classTrace.trace() || null == classTrace && null != methodTrace && !methodTrace.trace() || null != classTrace && classTrace.trace() && (null == methodTrace || !methodTrace.trace())) {
            return invocation.proceed();
        }
        Method method = invocation.getMethod();
        Entry interfaceEntry = null;
        Entry methodEntry = null;
        try {
            interfaceEntry = SphU.entry(method.getDeclaringClass().getName());
            methodEntry = SphU.entry(method, EntryType.OUT, 1, invocation.getArguments());
            ResourceWrapper rw = methodEntry.getResourceWrapper();
            if (ResourceHookManager.getResourceHook().needHock(rw.getName(), "CUSTOM")) {
                Object object = ResourceHookManager.getResourceHook().doHook(new HookTarget("CUSTOM", rw.getName(), invocation.getThis(), invocation.getMethod(), invocation.getArguments()){

                    @Override
                    public Object call() throws Throwable {
                        return invocation.proceed();
                    }
                });
                return object;
            }
            Object object = invocation.proceed();
            return object;
        }
        catch (Throwable e) {
            Tracer.traceEntry(e, interfaceEntry);
            Tracer.traceEntry(e, methodEntry);
            throw e;
        }
        finally {
            if (methodEntry != null) {
                methodEntry.exit(1, invocation.getArguments());
            }
            if (interfaceEntry != null) {
                interfaceEntry.exit();
            }
        }
    }
}

