/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.reactor;

import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.adapter.reactor.ContextConfig;
import com.alibaba.csp.sentinel.util.AssertUtil;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Supplier;

public class EntryConfig {
    private final String resourceName;
    private final Supplier<String> resourceSupplier;
    private final EntryType entryType;
    private final int resourceType;
    private final int acquireCount;
    private final Object[] args;
    private final Map<String, Object> argMap;
    private final ContextConfig contextConfig;

    public EntryConfig(String resourceName) {
        this(resourceName, EntryType.OUT);
    }

    public EntryConfig(Supplier<String> resourceSupplier, EntryType entryType) {
        this(resourceSupplier, 0, entryType, null, null);
    }

    public EntryConfig(String resourceName, EntryType entryType) {
        this(resourceName, entryType, null);
    }

    public EntryConfig(String resourceName, EntryType entryType, ContextConfig contextConfig) {
        this(resourceName, entryType, 1, new Object[0], contextConfig);
    }

    public EntryConfig(String resourceName, int resourceType, EntryType entryType, ContextConfig contextConfig) {
        this(resourceName, resourceType, entryType, 1, new Object[0], contextConfig);
    }

    public EntryConfig(String resourceName, EntryType entryType, int acquireCount, Object[] args) {
        this(resourceName, entryType, acquireCount, args, null);
    }

    public EntryConfig(String resourceName, EntryType entryType, int acquireCount, Object[] args, ContextConfig contextConfig) {
        this(resourceName, 0, entryType, acquireCount, args, contextConfig);
    }

    public EntryConfig(String resourceName, int resourceType, EntryType entryType, int acquireCount, Object[] args) {
        this(resourceName, resourceType, entryType, acquireCount, args, null);
    }

    public EntryConfig(String resourceName, int resourceType, EntryType entryType, Map<String, Object> argMap, ContextConfig contextConfig) {
        this(resourceName, null, resourceType, entryType, 1, null, argMap, contextConfig);
    }

    public EntryConfig(Supplier<String> resourceSupplier, int resourceType, EntryType entryType, Map<String, Object> argMap, ContextConfig contextConfig) {
        this(null, resourceSupplier, resourceType, entryType, 1, null, argMap, contextConfig);
    }

    public EntryConfig(String resourceName, int resourceType, EntryType entryType, int acquireCount, Object[] args, ContextConfig contextConfig) {
        this(resourceName, null, resourceType, entryType, acquireCount, args, null, contextConfig);
    }

    public EntryConfig(String resourceName, Supplier<String> resourceSupplier, int resourceType, EntryType entryType, int batchCount, Object[] args, Map<String, Object> argMap, ContextConfig contextConfig) {
        if (resourceName == null) {
            AssertUtil.assertNotNull(resourceSupplier, "resourceSupplier should be provided if resourceName is null");
        } else {
            AssertUtil.assertNotBlank(resourceName, "resourceName cannot be blank if resourceSupplier is absent");
        }
        AssertUtil.notNull((Object)entryType, "entryType cannot be null");
        AssertUtil.isTrue(batchCount > 0, "batchCount should be positive");
        this.resourceName = resourceName;
        this.resourceSupplier = resourceSupplier;
        this.entryType = entryType;
        this.resourceType = resourceType;
        this.acquireCount = batchCount;
        this.args = args;
        this.argMap = argMap;
        this.contextConfig = contextConfig;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public EntryType getEntryType() {
        return this.entryType;
    }

    public int getAcquireCount() {
        return this.acquireCount;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public ContextConfig getContextConfig() {
        return this.contextConfig;
    }

    public int getResourceType() {
        return this.resourceType;
    }

    public Supplier<String> getResourceSupplier() {
        return this.resourceSupplier;
    }

    public Map<String, Object> getArgMap() {
        return this.argMap;
    }

    public String toString() {
        return "EntryConfig{resourceName='" + this.resourceName + '\'' + ", resourceSupplier=" + this.resourceSupplier + ", entryType=" + (Object)((Object)this.entryType) + ", resourceType=" + this.resourceType + ", acquireCount=" + this.acquireCount + ", args=" + Arrays.toString(this.args) + ", argMap=" + this.argMap + ", contextConfig=" + this.contextConfig + '}';
    }
}

