/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.servlet;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.adapter.agent.AgentCompatibilityUtils;
import com.alibaba.csp.sentinel.adapter.servlet.callback.RequestOriginParser;
import com.alibaba.csp.sentinel.adapter.servlet.callback.UrlCleaner;
import com.alibaba.csp.sentinel.adapter.servlet.callback.WebCallbackManager;
import com.alibaba.csp.sentinel.adapter.servlet.callback.WebPassCallback;
import com.alibaba.csp.sentinel.adapter.servlet.param.HttpServletRequestItemParser;
import com.alibaba.csp.sentinel.adapter.servlet.util.FilterUtil;
import com.alibaba.csp.sentinel.context.ContextUtil;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.slots.block.flow.statuscode.StatusCodeMetricManager;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.csp.sentinel.web.adapter.common.param.WebParamParser;
import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CommonFilter
implements Filter {
    public static final String HTTP_METHOD_SPECIFY = "HTTP_METHOD_SPECIFY";
    public static final String WEB_CONTEXT_UNIFY = "WEB_CONTEXT_UNIFY";
    private static final String COLON = ":";
    private boolean httpMethodSpecify = false;
    private boolean webContextUnify = true;
    private final boolean shouldDetectAgent;
    private final WebPassCallback passCallback;
    private final WebParamParser<HttpServletRequest> webParamParser = new WebParamParser<HttpServletRequest>(new HttpServletRequestItemParser());
    private static final String EMPTY_ORIGIN = "";

    public CommonFilter() {
        this(true);
    }

    public CommonFilter(boolean shouldDetectAgent) {
        this(shouldDetectAgent, null);
    }

    public CommonFilter(boolean shouldDetectAgent, WebPassCallback passCallback) {
        this.shouldDetectAgent = shouldDetectAgent;
        this.passCallback = passCallback;
    }

    public void init(FilterConfig filterConfig) {
        this.httpMethodSpecify = Boolean.parseBoolean(filterConfig.getInitParameter(HTTP_METHOD_SPECIFY));
        if (filterConfig.getInitParameter(WEB_CONTEXT_UNIFY) != null) {
            this.webContextUnify = Boolean.parseBoolean(filterConfig.getInitParameter(WEB_CONTEXT_UNIFY));
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.shouldDetectAgent && AgentCompatibilityUtils.isAgentPresent()) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest sRequest = (HttpServletRequest)request;
        HttpServletResponse sResponse = (HttpServletResponse)response;
        Entry urlEntry = null;
        String resourceName = null;
        try {
            String target = FilterUtil.filterTarget(sRequest);
            UrlCleaner urlCleaner = WebCallbackManager.getUrlCleaner();
            if (urlCleaner != null) {
                target = urlCleaner.clean(target);
            }
            if (!StringUtil.isEmpty(target)) {
                String origin = this.parseOrigin(sRequest);
                String contextName = this.webContextUnify ? "sentinel_web_servlet_context" : target;
                ContextUtil.enter(contextName, origin);
                resourceName = this.httpMethodSpecify ? sRequest.getMethod().toUpperCase() + COLON + target : target;
                Map<String, Object> params = this.webParamParser.parseParameterFor(resourceName, sRequest, null);
                urlEntry = SphU.entry(resourceName, 1, EntryType.IN, params);
            }
            if (this.passCallback == null) {
                chain.doFilter(request, response);
            } else {
                this.passCallback.onPass(resourceName, request, response, chain);
            }
            if (!StringUtil.isEmpty(resourceName)) {
                int status = sResponse.getStatus();
                StatusCodeMetricManager.getInstance().recordStatusCode(resourceName, status);
            }
        }
        catch (BlockException e) {
            WebCallbackManager.getUrlBlockHandler().blocked(sRequest, sResponse, resourceName, e);
            if (!StringUtil.isEmpty(resourceName)) {
                int status = sResponse.getStatus();
                StatusCodeMetricManager.getInstance().recordStatusCode(resourceName, status);
            }
        }
        catch (IOException e2) {
            Tracer.traceEntry(e2, urlEntry);
            throw e2;
        }
        catch (ServletException e2) {
            Tracer.traceEntry(e2, urlEntry);
            throw e2;
        }
        catch (RuntimeException e2) {
            Tracer.traceEntry(e2, urlEntry);
            throw e2;
        }
        catch (Exception ex) {
            Tracer.traceEntry(ex, urlEntry);
            throw new ServletException((Throwable)ex);
        }
        finally {
            if (urlEntry != null) {
                urlEntry.exit();
            }
            ContextUtil.exit();
        }
    }

    private String parseOrigin(HttpServletRequest request) {
        RequestOriginParser originParser = WebCallbackManager.getRequestOriginParser();
        String origin = EMPTY_ORIGIN;
        if (originParser != null && StringUtil.isEmpty(origin = originParser.parseOrigin(request))) {
            return EMPTY_ORIGIN;
        }
        return origin;
    }

    public void destroy() {
    }
}

