/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.servlet;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.adapter.agent.AgentCompatibilityUtils;
import com.alibaba.csp.sentinel.adapter.servlet.callback.WebCallbackManager;
import com.alibaba.csp.sentinel.context.ContextUtil;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CommonTotalFilter
implements Filter {
    public static final String TOTAL_URL_REQUEST = "total-url-request";
    private final boolean shouldDetectAgent;

    public CommonTotalFilter() {
        this(true);
    }

    public CommonTotalFilter(boolean shouldDetectAgent) {
        this.shouldDetectAgent = shouldDetectAgent;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.shouldDetectAgent && AgentCompatibilityUtils.isAgentPresent()) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest sRequest = (HttpServletRequest)request;
        Entry entry = null;
        try {
            ContextUtil.enter("sentinel_web_servlet_context");
            entry = SphU.entry(TOTAL_URL_REQUEST, 1);
            chain.doFilter(request, response);
        }
        catch (BlockException e) {
            HttpServletResponse sResponse = (HttpServletResponse)response;
            WebCallbackManager.getUrlBlockHandler().blocked(sRequest, sResponse, TOTAL_URL_REQUEST, e);
        }
        catch (IOException e2) {
            Tracer.trace(e2);
            throw e2;
        }
        catch (ServletException e2) {
            Tracer.trace(e2);
            throw e2;
        }
        catch (RuntimeException e2) {
            Tracer.trace(e2);
            throw e2;
        }
        finally {
            if (entry != null) {
                entry.exit();
            }
            ContextUtil.exit();
        }
    }

    public void destroy() {
    }
}

