/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.servlet.config;

import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.StringUtil;

public final class WebServletConfig {
    public static final String WEB_SERVLET_CONTEXT_NAME = "sentinel_web_servlet_context";
    public static final String BLOCK_PAGE_URL_CONF_KEY = "csp.sentinel.web.servlet.block.page";
    public static final String BLOCK_PAGE_HTTP_STATUS_CONF_KEY = "csp.sentinel.web.servlet.block.status";
    public static final String BLOCK_PAGE_ALLOW_ORIGINS_CONF_KEY = "csp.sentinel.web.servlet.block.cors-allow-origins";
    private static final int HTTP_STATUS_TOO_MANY_REQUESTS = 429;

    public static String getBlockPage() {
        return SentinelConfig.getConfig(BLOCK_PAGE_URL_CONF_KEY);
    }

    public static void setBlockPage(String blockPage) {
        SentinelConfig.setConfig(BLOCK_PAGE_URL_CONF_KEY, blockPage);
    }

    public static int getBlockPageHttpStatus() {
        String value = SentinelConfig.getConfig(BLOCK_PAGE_HTTP_STATUS_CONF_KEY);
        if (StringUtil.isEmpty(value)) {
            return 429;
        }
        try {
            int s = Integer.parseInt(value);
            if (s <= 0) {
                throw new IllegalArgumentException("Invalid status code: " + s);
            }
            return s;
        }
        catch (Exception e) {
            RecordLog.warn("[WebServletConfig] Invalid block HTTP status (" + value + "), using default 429", new Object[0]);
            WebServletConfig.setBlockPageHttpStatus(429);
            return 429;
        }
    }

    public static void setBlockPageHttpStatus(int httpStatus) {
        if (httpStatus <= 0) {
            throw new IllegalArgumentException("Invalid HTTP status code: " + httpStatus);
        }
        SentinelConfig.setConfig(BLOCK_PAGE_HTTP_STATUS_CONF_KEY, String.valueOf(httpStatus));
    }

    public static String getAllowOriginsForDefaultBlockPage() {
        return SentinelConfig.getConfig(BLOCK_PAGE_ALLOW_ORIGINS_CONF_KEY);
    }

    public static void setAllowOriginsForDefaultBlockPage(String allowOrigins) {
        if (StringUtil.isBlank(allowOrigins)) {
            SentinelConfig.removeConfig(BLOCK_PAGE_ALLOW_ORIGINS_CONF_KEY);
            return;
        }
        SentinelConfig.setConfig(BLOCK_PAGE_ALLOW_ORIGINS_CONF_KEY, allowOrigins);
    }

    private WebServletConfig() {
    }
}

