/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.servlet.util;

import com.alibaba.csp.sentinel.adapter.servlet.config.WebServletConfig;
import com.alibaba.csp.sentinel.setting.adapter.AdapterSettingManager;
import com.alibaba.csp.sentinel.setting.fallback.BlockFallbackConfig;
import com.alibaba.csp.sentinel.setting.fallback.BlockFallbackUtils;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class FilterUtil {
    private static final String PATH_SPLIT = "/";
    public static final String DEFAULT_BLOCK_MSG = "Blocked by Sentinel (flow limiting)";

    public static String filterTarget(HttpServletRequest request) {
        String pathInfo = FilterUtil.getResourcePath(request);
        if (!pathInfo.startsWith(PATH_SPLIT)) {
            pathInfo = PATH_SPLIT + pathInfo;
        }
        if (PATH_SPLIT.equals(pathInfo)) {
            return pathInfo;
        }
        int lastSlashIndex = pathInfo.lastIndexOf(PATH_SPLIT);
        pathInfo = lastSlashIndex >= 0 ? pathInfo.substring(0, lastSlashIndex) + PATH_SPLIT + StringUtil.trim(pathInfo.substring(lastSlashIndex + 1)) : PATH_SPLIT + StringUtil.trim(pathInfo);
        return pathInfo;
    }

    public static void blockRequest(HttpServletRequest request, HttpServletResponse response, String resourceName, BlockException ex) throws IOException {
        BlockFallbackConfig.WebBlockFallbackBehavior b;
        String allowOrigins;
        StringBuffer url = request.getRequestURL();
        if ("GET".equals(request.getMethod()) && StringUtil.isNotBlank(request.getQueryString())) {
            url.append("?").append(request.getQueryString());
        }
        if (StringUtil.isNotBlank(allowOrigins = WebServletConfig.getAllowOriginsForDefaultBlockPage())) {
            response.setHeader("Access-Control-Allow-Origin", allowOrigins);
        }
        if ((b = BlockFallbackUtils.getFallbackBehavior(resourceName, ex)) != null) {
            FilterUtil.writeBlockPageWith(response, b);
        } else if (StringUtil.isBlank(WebServletConfig.getBlockPage())) {
            FilterUtil.writeDefaultBlockedPage(response, WebServletConfig.getBlockPageHttpStatus());
        } else {
            String redirectUrl = WebServletConfig.getBlockPage() + "?http_referer=" + url.toString();
            response.sendRedirect(redirectUrl);
        }
    }

    private static void writeBlockPageWith(HttpServletResponse response, BlockFallbackConfig.WebBlockFallbackBehavior b) throws IOException {
        Integer contentType;
        int status = 429;
        if (b.getWebRespStatusCode() != null && b.getWebRespStatusCode() > 0) {
            status = b.getWebRespStatusCode();
        }
        if ((contentType = b.getWebRespContentType()) != null && contentType == 1) {
            FilterUtil.setContentTypeToJson(response);
        }
        response.setStatus(status);
        FilterUtil.setCharsetToUtf8(response);
        PrintWriter out = response.getWriter();
        out.print(b.getWebRespMessage());
        out.flush();
        out.close();
    }

    private static void writeDefaultBlockedPage(HttpServletResponse response, int httpStatus) throws IOException {
        response.setStatus(httpStatus);
        FilterUtil.setCharsetToUtf8(response);
        Integer contentType = AdapterSettingManager.getWebRespContentType();
        if (contentType != null && contentType.equals(1)) {
            FilterUtil.setContentTypeToJson(response);
        }
        String respMessage = FilterUtil.valueOrDefault(AdapterSettingManager.getWebRespMessage(), DEFAULT_BLOCK_MSG);
        PrintWriter out = response.getWriter();
        out.print(respMessage);
        out.flush();
        out.close();
    }

    private static void setContentTypeToJson(HttpServletResponse response) {
        response.setContentType("application/json");
    }

    private static void setCharsetToUtf8(HttpServletResponse response) {
        response.setCharacterEncoding("utf-8");
    }

    private static <R> R valueOrDefault(R nullable, R defaultValue) {
        return nullable == null ? defaultValue : nullable;
    }

    private static String getResourcePath(HttpServletRequest request) {
        String pathInfo = FilterUtil.normalizeAbsolutePath(request.getPathInfo(), false);
        String servletPath = FilterUtil.normalizeAbsolutePath(request.getServletPath(), pathInfo.length() != 0);
        return servletPath + pathInfo;
    }

    private static String normalizeAbsolutePath(String path, boolean removeTrailingSlash) throws IllegalStateException {
        return FilterUtil.normalizePath(path, true, false, removeTrailingSlash);
    }

    private static String normalizePath(String path, boolean forceAbsolute, boolean forceRelative, boolean removeTrailingSlash) throws IllegalStateException {
        char[] pathChars = StringUtil.trimToEmpty(path).toCharArray();
        int length = pathChars.length;
        boolean startsWithSlash = false;
        boolean endsWithSlash = false;
        if (length > 0) {
            char firstChar = pathChars[0];
            char lastChar = pathChars[length - 1];
            startsWithSlash = firstChar == PATH_SPLIT.charAt(0) || firstChar == '\\';
            endsWithSlash = lastChar == PATH_SPLIT.charAt(0) || lastChar == '\\';
        }
        StringBuilder buf = new StringBuilder(length);
        boolean isAbsolutePath = forceAbsolute || !forceRelative && startsWithSlash;
        int index = startsWithSlash ? 0 : -1;
        int level = 0;
        if (isAbsolutePath) {
            buf.append(PATH_SPLIT);
        }
        while (index < length && (index = FilterUtil.indexOfSlash(pathChars, index + 1, false)) != length) {
            int nextSlashIndex = FilterUtil.indexOfSlash(pathChars, index, true);
            String element = new String(pathChars, index, nextSlashIndex - index);
            index = nextSlashIndex;
            if (".".equals(element)) continue;
            if ("..".equals(element)) {
                if (level == 0) {
                    if (isAbsolutePath) {
                        throw new IllegalStateException(path);
                    }
                    buf.append("..").append(PATH_SPLIT);
                    continue;
                }
                buf.setLength(pathChars[--level]);
                continue;
            }
            pathChars[level++] = (char)buf.length();
            buf.append(element).append(PATH_SPLIT);
        }
        if (buf.length() > 0 && (!endsWithSlash || removeTrailingSlash)) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    private static int indexOfSlash(char[] chars, int beginIndex, boolean slash) {
        int i;
        for (i = beginIndex; i < chars.length; ++i) {
            char ch = chars[i];
            if (slash ? ch == PATH_SPLIT.charAt(0) || ch == '\\' : ch != PATH_SPLIT.charAt(0) && ch != '\\') break;
        }
        return i;
    }

    private FilterUtil() {
    }
}

