/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.sofa.rpc;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.AbstractInterfaceConfig;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.filter.Filter;
import com.alipay.sofa.rpc.filter.FilterInvoker;

public abstract class BaseSentinelFilter
extends Filter {
    public static String getCallerAppName(SofaRequest request) {
        String appName = (String)request.getRequestProp("app");
        return StringUtil.isBlank(appName) ? "" : appName;
    }

    protected String extractMethodName(SofaRequest request) {
        StringBuilder buf = new StringBuilder(32);
        buf.append(request.getInterfaceName()).append('#').append(request.getMethodName()).append('(');
        boolean isFirst = true;
        for (String mpt : request.getMethodArgSigs()) {
            if (!isFirst) {
                buf.append(",");
            }
            buf.append(mpt);
            isFirst = false;
        }
        buf.append(")");
        return buf.toString();
    }

    protected void traceExceptionIfNeeded(SofaResponse response, Entry methodEntry, Entry interfaceEntry) {
        if (response.isError()) {
            RuntimeException ex = new RuntimeException(response.getErrorMsg());
            Tracer.traceEntry(ex, methodEntry);
            Tracer.traceEntry(ex, interfaceEntry);
        } else {
            Object appResponse = response.getAppResponse();
            if (appResponse instanceof Throwable) {
                Tracer.traceEntry((Throwable)appResponse, methodEntry);
                Tracer.traceEntry((Throwable)appResponse, interfaceEntry);
            }
        }
    }

    public boolean needToLoad(FilterInvoker invoker) {
        AbstractInterfaceConfig config = invoker.getConfig();
        String enabled = config.getParameter("sofa.rpc.sentinel.enabled");
        if (StringUtils.isNotBlank((CharSequence)enabled)) {
            return Boolean.parseBoolean(enabled);
        }
        return (Boolean)RpcConfigs.getOrDefaultValue((String)"sofa.rpc.sentinel.enabled", (Object)true);
    }
}

