/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.sofa.rpc.fallback;

import com.alibaba.csp.sentinel.adapter.sofa.rpc.fallback.SofaRpcFallback;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.setting.fallback.BlockFallbackConfig;
import com.alibaba.csp.sentinel.setting.fallback.BlockFallbackUtils;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.util.function.Tuple2;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.invoke.Invoker;

public class DefaultSofaRpcFallback
implements SofaRpcFallback {
    @Override
    public SofaResponse handle(Invoker invoker, SofaRequest request, BlockException ex, String resourceName) {
        SofaResponse response = new SofaResponse();
        try {
            Tuple2<Object, BlockFallbackConfig.RpcBlockFallbackBehavior> fallbackPair = BlockFallbackUtils.getRpcFallbackInstance(resourceName, ex);
            if (fallbackPair == null) {
                response.setErrorMsg("SentinelBlockException: " + ex.getClass().getSimpleName());
                return response;
            }
            if (((BlockFallbackConfig.RpcBlockFallbackBehavior)fallbackPair.r2).getRpcFallbackMode() == 0) {
                response.setAppResponse(fallbackPair.r1);
                return response;
            }
            response.setAppResponse(fallbackPair.r1);
            response.setErrorMsg("SentinelBlockException: " + fallbackPair.r1.getClass().getSimpleName());
            return response;
        }
        catch (Throwable t) {
            RecordLog.warn("[SofaRpcReflectCustomException] Custom rpc fallback error", t);
            throw BlockException.THROW_OUT_EXCEPTION;
        }
    }
}

