/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.spring.resttemplate;

import com.alibaba.csp.sentinel.util.AssertUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.client.AbstractClientHttpResponse;

public class SentinelClientHttpResponse
extends AbstractClientHttpResponse {
    public static final String DEFAULT_BLOCK_RESPONSE = "RestTemplate request blocked by Sentinel";
    private final String blockResponse;
    private final MediaType contentType;
    private final HttpStatus statusCode;

    public SentinelClientHttpResponse() {
        this(DEFAULT_BLOCK_RESPONSE);
    }

    public SentinelClientHttpResponse(String blockResponse) {
        this(blockResponse, MediaType.TEXT_PLAIN);
    }

    public SentinelClientHttpResponse(String blockResponse, MediaType contentType) {
        this(blockResponse, contentType, HttpStatus.TOO_MANY_REQUESTS);
    }

    public SentinelClientHttpResponse(String blockResponse, MediaType contentType, HttpStatus statusCode) {
        AssertUtil.notEmpty(blockResponse, "blockResponse cannot be empty");
        AssertUtil.assertNotNull(contentType, "contentType cannot be null");
        this.blockResponse = blockResponse;
        this.contentType = contentType;
        this.statusCode = statusCode;
    }

    public int getRawStatusCode() throws IOException {
        return this.statusCode.value();
    }

    public String getStatusText() throws IOException {
        return this.blockResponse;
    }

    public void close() {
    }

    public InputStream getBody() throws IOException {
        return new ByteArrayInputStream(this.blockResponse.getBytes());
    }

    public HttpHeaders getHeaders() {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>(4);
        headers.put("Content-Type", Arrays.asList(this.contentType.toString()));
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.putAll(headers);
        return httpHeaders;
    }
}

