/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.spring.resttemplate;

import com.alibaba.csp.sentinel.adapter.spring.resttemplate.BlockClassRegistry;
import com.alibaba.csp.sentinel.adapter.spring.resttemplate.SentinelRestTemplateRequestInterceptor;
import com.alibaba.csp.sentinel.adapter.spring.resttemplate.annotation.SentinelRestTemplate;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.StandardMethodMetadata;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class SentinelRestTemplateBeanPostProcessor
implements MergedBeanDefinitionPostProcessor {
    private final ApplicationContext applicationContext;
    public static final String BLOCK_TYPE = "block";
    public static final String FALLBACK_TYPE = "fallback";
    public static final String URL_CLEANER_TYPE = "urlCleaner";
    private ConcurrentMap<String, SentinelRestTemplate> cache = new ConcurrentHashMap<String, SentinelRestTemplate>();

    public SentinelRestTemplateBeanPostProcessor(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Class<?> beanType, String beanName) {
        if (this.checkSentinelProtect(beanDefinition, beanType, beanName)) {
            SentinelRestTemplate sentinelRestTemplate = null;
            if (beanDefinition.getSource() instanceof StandardMethodMetadata) {
                sentinelRestTemplate = ((StandardMethodMetadata)beanDefinition.getSource()).getIntrospectedMethod().getAnnotation(SentinelRestTemplate.class);
            } else if (beanDefinition.getResolvedFactoryMethod() != null) {
                sentinelRestTemplate = beanDefinition.getResolvedFactoryMethod().getAnnotation(SentinelRestTemplate.class);
            }
            this.checkSentinelRestTemplate(sentinelRestTemplate, beanName);
            this.cache.put(beanName, sentinelRestTemplate);
        }
    }

    private void checkSentinelRestTemplate(SentinelRestTemplate sentinelRestTemplate, String beanName) {
        if (sentinelRestTemplate == null) {
            RecordLog.warn("checkSentinelRestTemplate @SentinelRestTemplate annotation not present, beanName={}", beanName);
            return;
        }
        this.checkBlock4RestTemplate(sentinelRestTemplate.blockHandlerClass(), sentinelRestTemplate.blockHandler(), beanName, BLOCK_TYPE);
        this.checkBlock4RestTemplate(sentinelRestTemplate.fallbackClass(), sentinelRestTemplate.fallback(), beanName, FALLBACK_TYPE);
        this.checkBlock4RestTemplate(sentinelRestTemplate.urlCleanerClass(), sentinelRestTemplate.urlCleaner(), beanName, URL_CLEANER_TYPE);
    }

    private void checkBlock4RestTemplate(Class<?> blockClass, String blockMethod, String beanName, String type) {
        if (blockClass == Void.TYPE && StringUtils.isEmpty((Object)blockMethod)) {
            return;
        }
        if (blockClass != Void.TYPE && StringUtils.isEmpty((Object)blockMethod)) {
            throw new IllegalArgumentException(type + " class attribute exists but " + type + " method attribute is not exists in bean [" + beanName + "]");
        }
        if (blockClass == Void.TYPE && !StringUtils.isEmpty((Object)blockMethod)) {
            throw new IllegalArgumentException(type + " method attribute exists but " + type + " class attribute is not exists in bean [" + beanName + "]");
        }
        Class[] args = URL_CLEANER_TYPE.equals(type) ? new Class[]{String.class} : (BLOCK_TYPE.equals(type) ? new Class[]{HttpRequest.class, byte[].class, ClientHttpRequestExecution.class, BlockException.class} : new Class[]{HttpRequest.class, byte[].class, ClientHttpRequestExecution.class, Throwable.class});
        ArrayList<String> strs = new ArrayList<String>();
        for (Class clazz : args) {
            strs.add(clazz.getSimpleName());
        }
        String argsStr = Arrays.toString(strs.toArray());
        Method foundMethod = ClassUtils.getStaticMethod(blockClass, (String)blockMethod, (Class[])args);
        if (foundMethod == null) {
            throw new IllegalArgumentException(type + " static method can not be found in bean[" + beanName + "]. The right method signature is " + blockClass.getName() + "#" + blockMethod + argsStr + ", please check your class name, method name and arguments");
        }
        Class standardReturnType = type.equals(URL_CLEANER_TYPE) ? String.class : ClientHttpResponse.class;
        if (!standardReturnType.isAssignableFrom(foundMethod.getReturnType())) {
            throw new IllegalArgumentException(type + " method return value in bean[" + beanName + "] is not " + standardReturnType.getName() + ": " + blockClass.getName() + "#" + blockMethod + argsStr);
        }
        if (type.equals(BLOCK_TYPE)) {
            BlockClassRegistry.updateBlockHandlerFor(blockClass, blockMethod, foundMethod);
        } else if (type.equals(FALLBACK_TYPE)) {
            BlockClassRegistry.updateFallbackFor(blockClass, blockMethod, foundMethod);
        } else {
            BlockClassRegistry.updateUrlCleanerFor(blockClass, blockMethod, foundMethod);
        }
    }

    private boolean checkSentinelProtect(RootBeanDefinition beanDefinition, Class<?> beanType, String beanName) {
        return beanName != null && beanType == RestTemplate.class && this.checkMethodMetadataReadingVisitor(beanDefinition);
    }

    private boolean checkMethodMetadataReadingVisitor(RootBeanDefinition beanDefinition) {
        return beanDefinition.getSource() instanceof MethodMetadata && ((MethodMetadata)beanDefinition.getSource()).isAnnotated(SentinelRestTemplate.class.getName());
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (beanName != null && this.cache.containsKey(beanName)) {
            StringBuilder interceptorBeanNamePrefix = new StringBuilder();
            SentinelRestTemplate sentinelRestTemplate = (SentinelRestTemplate)this.cache.get(beanName);
            interceptorBeanNamePrefix.append(StringUtils.uncapitalize((String)SentinelRestTemplateRequestInterceptor.class.getSimpleName())).append("_").append(sentinelRestTemplate.blockHandlerClass().getSimpleName()).append(sentinelRestTemplate.blockHandler()).append("_").append(sentinelRestTemplate.fallbackClass().getSimpleName()).append(sentinelRestTemplate.fallback()).append("_").append(sentinelRestTemplate.urlCleanerClass().getSimpleName()).append(sentinelRestTemplate.urlCleaner());
            RestTemplate restTemplate = (RestTemplate)bean;
            String interceptorBeanName = interceptorBeanNamePrefix + "@" + bean.toString();
            this.registerBean(interceptorBeanName, sentinelRestTemplate, (RestTemplate)bean);
            SentinelRestTemplateRequestInterceptor sentinelRestTemplateRequestInterceptor = (SentinelRestTemplateRequestInterceptor)this.applicationContext.getBean(interceptorBeanName, SentinelRestTemplateRequestInterceptor.class);
            restTemplate.getInterceptors().add(0, sentinelRestTemplateRequestInterceptor);
        }
        return bean;
    }

    private void registerBean(String interceptorBeanName, SentinelRestTemplate sentinelRestTemplate, RestTemplate restTemplate) {
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)this.applicationContext.getAutowireCapableBeanFactory();
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(SentinelRestTemplateRequestInterceptor.class);
        beanDefinitionBuilder.addConstructorArgValue((Object)sentinelRestTemplate);
        beanDefinitionBuilder.addConstructorArgValue((Object)restTemplate);
        AbstractBeanDefinition interceptorBeanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
        beanFactory.registerBeanDefinition(interceptorBeanName, (BeanDefinition)interceptorBeanDefinition);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

