/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.spring.resttemplate;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.adapter.spring.resttemplate.BlockClassRegistry;
import com.alibaba.csp.sentinel.adapter.spring.resttemplate.SentinelClientHttpResponse;
import com.alibaba.csp.sentinel.adapter.spring.resttemplate.annotation.SentinelRestTemplate;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.RestTemplate;

public class SentinelRestTemplateRequestInterceptor
implements ClientHttpRequestInterceptor {
    private final SentinelRestTemplate sentinelRestTemplate;
    private final RestTemplate restTemplate;

    public SentinelRestTemplateRequestInterceptor(SentinelRestTemplate sentinelRestTemplate, RestTemplate restTemplate) {
        this.sentinelRestTemplate = sentinelRestTemplate;
        this.restTemplate = restTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        URI uri = request.getURI();
        String httpMethodPrefix = request.getMethod() != null ? request.getMethod().toString() + ":" : "";
        String hostWithPathResource = httpMethodPrefix + uri.getScheme() + "://" + uri.getHost() + (uri.getPort() == -1 ? "" : ":" + uri.getPort()) + uri.getPath();
        Method urlCleanerMethod = BlockClassRegistry.lookupUrlCleaner(this.sentinelRestTemplate.urlCleanerClass(), this.sentinelRestTemplate.urlCleaner());
        if (urlCleanerMethod != null) {
            hostWithPathResource = (String)this.methodInvoke(urlCleanerMethod, hostWithPathResource);
        }
        Entry hostWithPathEntry = null;
        ClientHttpResponse response = null;
        try {
            hostWithPathEntry = SphU.entry(hostWithPathResource, 1, EntryType.OUT);
            response = execution.execute(request, body);
            if (response != null && this.restTemplate.getErrorHandler().hasError(response)) {
                Tracer.traceEntry(new IllegalStateException("RestTemplate ErrorHandler has error:" + response.getStatusText()), hostWithPathEntry);
            }
            ClientHttpResponse clientHttpResponse = response;
            return clientHttpResponse;
        }
        catch (Throwable e) {
            if (!BlockException.isBlockException(e)) {
                Tracer.traceEntry(e, hostWithPathEntry);
            }
            try {
                ClientHttpResponse clientHttpResponse = this.handleException(request, body, execution, e);
                return clientHttpResponse;
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Error ex) {
                throw ex;
            }
            catch (Throwable t) {
                SentinelClientHttpResponse sentinelClientHttpResponse = new SentinelClientHttpResponse(t.toString(), MediaType.APPLICATION_JSON_UTF8, HttpStatus.INTERNAL_SERVER_ERROR);
                return sentinelClientHttpResponse;
            }
        }
        finally {
            if (hostWithPathEntry != null) {
                hostWithPathEntry.exit();
            }
        }
    }

    private ClientHttpResponse handleException(HttpRequest request, byte[] body, ClientHttpRequestExecution execution, Throwable t) throws Throwable {
        Method blockHandler;
        Object[] args = new Object[]{request, body, execution, t};
        if (t instanceof BlockException && (blockHandler = this.extractBlockHandlerMethod(this.sentinelRestTemplate.blockHandler(), this.sentinelRestTemplate.blockHandlerClass())) != null) {
            return (ClientHttpResponse)this.methodInvoke(blockHandler, args);
        }
        Method fallbackMethod = this.extractFallbackMethod(this.sentinelRestTemplate.fallback(), this.sentinelRestTemplate.fallbackClass());
        if (fallbackMethod != null) {
            return (ClientHttpResponse)this.methodInvoke(fallbackMethod, args);
        }
        if (t instanceof BlockException) {
            return new SentinelClientHttpResponse();
        }
        throw t;
    }

    private Object methodInvoke(Method method, Object ... args) {
        try {
            return method.invoke(null, args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Method extractFallbackMethod(String fallback, Class<?> fallbackClass) {
        return BlockClassRegistry.lookupFallback(fallbackClass, fallback);
    }

    private Method extractBlockHandlerMethod(String block, Class<?> blockClass) {
        return BlockClassRegistry.lookupBlockHandler(blockClass, block);
    }
}

