/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.spring.webflux;

import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.adapter.reactor.ContextConfig;
import com.alibaba.csp.sentinel.adapter.reactor.EntryConfig;
import com.alibaba.csp.sentinel.adapter.reactor.SentinelReactorTransformer;
import com.alibaba.csp.sentinel.adapter.spring.webflux.callback.WebFluxCallbackManager;
import com.alibaba.csp.sentinel.adapter.spring.webflux.param.ServerWebExchangeItemParser;
import com.alibaba.csp.sentinel.slots.block.flow.statuscode.StatusCodeMetricManager;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.csp.sentinel.web.adapter.common.param.WebParamParser;
import java.util.Map;
import java.util.Optional;
import org.springframework.core.Ordered;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class SentinelWebFluxFilter
implements WebFilter,
Ordered {
    public static final String WEBFLUX_CONTEXT_NAME = "sentinel_spring_webflux_context";
    public static final String WEBFLUX_RESOURCE_ATTR_KEY = "$$sentinel_spring_webflux_resource_name";
    private final int order;
    protected final WebParamParser<ServerWebExchange> webParamParser;
    private static final String EMPTY_ORIGIN = "";

    public SentinelWebFluxFilter() {
        this(0);
    }

    public SentinelWebFluxFilter(int order) {
        this.order = order;
        this.webParamParser = new WebParamParser<ServerWebExchange>(new ServerWebExchangeItemParser());
    }

    public int getOrder() {
        return this.order;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        String path = exchange.getRequest().getPath().value();
        String finalPath = WebFluxCallbackManager.getUrlCleaner().apply(exchange, path);
        if (StringUtil.isEmpty(finalPath)) {
            return chain.filter(exchange);
        }
        return chain.filter(exchange).transform(this.setAttrAndBuildSentinelTransformer(exchange, finalPath)).doFinally(t -> Optional.ofNullable(exchange.getResponse().getStatusCode()).ifPresent(status -> StatusCodeMetricManager.getInstance().recordStatusCode(finalPath, status.value())));
    }

    private SentinelReactorTransformer<Void> setAttrAndBuildSentinelTransformer(ServerWebExchange exchange, String finalPath) {
        String origin = Optional.ofNullable(WebFluxCallbackManager.getRequestOriginParser()).map(f -> (String)f.apply(exchange)).orElse(EMPTY_ORIGIN);
        exchange.getAttributes().putIfAbsent(WEBFLUX_RESOURCE_ATTR_KEY, finalPath);
        Map<String, Object> params = this.webParamParser.parseParameterFor(finalPath, exchange, null);
        return new SentinelReactorTransformer<Void>(new EntryConfig(finalPath, 1, EntryType.IN, params, new ContextConfig(WEBFLUX_CONTEXT_NAME, origin)));
    }
}

