/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.spring.webflux.callback;

import com.alibaba.csp.sentinel.adapter.spring.webflux.callback.BlockRequestHandler;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.setting.adapter.AdapterSettingManager;
import com.alibaba.csp.sentinel.setting.fallback.BlockFallbackConfig;
import com.alibaba.csp.sentinel.setting.fallback.BlockFallbackUtils;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.util.ObjectUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class DefaultBlockRequestHandler
implements BlockRequestHandler {
    private static final String DEFAULT_BLOCK_MSG_PREFIX = "Blocked by Sentinel: ";

    @Override
    public Mono<ServerResponse> handleRequest(ServerWebExchange exchange, String resource, Throwable ex) {
        if (!(ex instanceof BlockException)) {
            return this.handleDefaultBlockFallback(exchange, ex);
        }
        BlockException be = (BlockException)ex;
        BlockFallbackConfig.WebBlockFallbackBehavior b = Optional.ofNullable(BlockFallbackUtils.getFallbackBehavior(resource, be)).orElseGet(AdapterSettingManager::getCurrentGlobalWebBehavior);
        if (b != null) {
            return this.handleBlockFallbackWithBehavior(exchange, ex, b);
        }
        return this.handleDefaultBlockFallback(exchange, ex);
    }

    private Mono<ServerResponse> handleBlockFallbackWithBehavior(ServerWebExchange exchange, Throwable ex, BlockFallbackConfig.WebBlockFallbackBehavior b) {
        Integer contentType;
        if (ObjectUtil.equals(b.getWebFallbackMode(), 1)) {
            try {
                return ServerResponse.temporaryRedirect((URI)URI.create(b.getWebRedirectUrl())).build();
            }
            catch (Exception e) {
                RecordLog.warn("Spring WebFlux DefaultBlockHandler sendRedirect failed", e);
                return this.handleDefaultBlockFallback(exchange, ex);
            }
        }
        int status = 429;
        if (b.getWebRespStatusCode() != null && b.getWebRespStatusCode() > 0) {
            status = b.getWebRespStatusCode();
        }
        if ((contentType = b.getWebRespContentType()) == null) {
            contentType = 1;
        }
        String message = b.getWebRespMessage();
        if (contentType == 1) {
            if (StringUtil.isBlank(message)) {
                return this.buildDefaultJsonErrorResponse(ex);
            }
            return ServerResponse.status((int)status).contentType(MediaType.APPLICATION_JSON_UTF8).syncBody((Object)message);
        }
        if (StringUtil.isBlank(message)) {
            message = DEFAULT_BLOCK_MSG_PREFIX + ex.getClass().getSimpleName();
        }
        return ServerResponse.status((int)status).contentType(MediaType.TEXT_PLAIN).syncBody((Object)message);
    }

    private Mono<ServerResponse> handleDefaultBlockFallback(ServerWebExchange exchange, Throwable ex) {
        if (this.acceptsHtml(exchange)) {
            return this.htmlErrorResponse(ex);
        }
        return this.buildDefaultJsonErrorResponse(ex);
    }

    private Mono<ServerResponse> htmlErrorResponse(Throwable ex) {
        return ServerResponse.status((HttpStatus)HttpStatus.TOO_MANY_REQUESTS).contentType(MediaType.TEXT_PLAIN).syncBody((Object)(DEFAULT_BLOCK_MSG_PREFIX + ex.getClass().getSimpleName()));
    }

    private Mono<ServerResponse> buildDefaultJsonErrorResponse(Throwable ex) {
        return ServerResponse.status((HttpStatus)HttpStatus.TOO_MANY_REQUESTS).contentType(MediaType.APPLICATION_JSON_UTF8).body(BodyInserters.fromObject((Object)this.buildErrorResult(ex)));
    }

    private ErrorResult buildErrorResult(Throwable ex) {
        return new ErrorResult(HttpStatus.TOO_MANY_REQUESTS.value(), DEFAULT_BLOCK_MSG_PREFIX + ex.getClass().getSimpleName());
    }

    private boolean acceptsHtml(ServerWebExchange exchange) {
        try {
            List acceptedMediaTypes = exchange.getRequest().getHeaders().getAccept();
            acceptedMediaTypes.remove(MediaType.ALL);
            MediaType.sortBySpecificityAndQuality((List)acceptedMediaTypes);
            return acceptedMediaTypes.stream().anyMatch(arg_0 -> ((MediaType)MediaType.TEXT_HTML).isCompatibleWith(arg_0));
        }
        catch (InvalidMediaTypeException ex) {
            return false;
        }
    }

    private static class ErrorResult {
        private final int code;
        private final String message;

        ErrorResult(int code, String message) {
            this.code = code;
            this.message = message;
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

