/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.tair;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.taobao.tair.Result;
import com.taobao.tair.ResultCode;
import com.taobao.tair.TairManager;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class TairGroupInterceptor
implements MethodInterceptor {
    private static final String TAIR = "tair";
    private static final String SPLIT = ":";

    public Object invoke(MethodInvocation arg0) throws Throwable {
        Method executed = arg0.getMethod();
        if (Modifier.isPrivate(executed.getModifiers()) || Modifier.isProtected(executed.getModifiers())) {
            return arg0.proceed();
        }
        Object obj = arg0.getThis();
        if (!(obj instanceof TairManager)) {
            return arg0.proceed();
        }
        TairManager tairManager = (TairManager)obj;
        if (!executed.getReturnType().isAssignableFrom(Result.class) && !executed.getReturnType().isAssignableFrom(ResultCode.class)) {
            return arg0.proceed();
        }
        String configId = tairManager.getConfigId();
        if (configId == null || configId.isEmpty()) {
            return arg0.proceed();
        }
        String key = "tair:" + configId;
        if (key == null || key.isEmpty()) {
            return arg0.proceed();
        }
        Entry entry = null;
        try {
            Object result;
            entry = SphU.entry(key, 5, EntryType.OUT);
            Object object = result = arg0.proceed();
            return object;
        }
        catch (Throwable t) {
            Tracer.traceEntry(t, entry);
            throw t;
        }
        finally {
            if (entry != null) {
                entry.exit();
            }
        }
    }
}

