/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.tair;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.taobao.csp.sentinel.ResourceHookManager;
import com.taobao.csp.sentinel.hook.HookTarget;
import com.taobao.tair.Result;
import com.taobao.tair.ResultCode;
import com.taobao.tair.TairManager;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class TairGroupNamespaceInterceptor
implements MethodInterceptor {
    private static final String TAIR = "tair";
    private static final String SPLIT = ":";

    public Object invoke(MethodInvocation arg0) throws Throwable {
        Method executed = arg0.getMethod();
        if (Modifier.isPrivate(executed.getModifiers()) || Modifier.isProtected(executed.getModifiers())) {
            return arg0.proceed();
        }
        Object obj = arg0.getThis();
        if (!(obj instanceof TairManager)) {
            return arg0.proceed();
        }
        TairManager tairManager = (TairManager)obj;
        if (!executed.getReturnType().isAssignableFrom(Result.class) && !executed.getReturnType().isAssignableFrom(ResultCode.class)) {
            return arg0.proceed();
        }
        Object[] params = arg0.getArguments();
        if (params.length == 0) {
            return arg0.proceed();
        }
        String configId = tairManager.getConfigId();
        if (configId == null || configId.isEmpty()) {
            return arg0.proceed();
        }
        String namespaceKey = "tair:" + configId + SPLIT + params[0].toString();
        Entry namespaceEntry = null;
        try {
            namespaceEntry = SphU.entry(namespaceKey, 5, EntryType.OUT);
            final MethodInvocation invocation = arg0;
            Object result = ResourceHookManager.getResourceHook().needHock(namespaceKey, "TAIR") ? ResourceHookManager.getResourceHook().doHook(new HookTarget("TAIR", namespaceKey, arg0.getThis(), arg0.getMethod(), arg0.getArguments()){

                @Override
                public Object call() throws Throwable {
                    return invocation.proceed();
                }
            }) : arg0.proceed();
            Object object = result;
            return object;
        }
        catch (Throwable t) {
            Tracer.traceEntry(t, namespaceEntry);
            throw t;
        }
        finally {
            if (namespaceEntry != null) {
                namespaceEntry.exit();
            }
        }
    }
}

