/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adaptive;

import com.alibaba.csp.sentinel.util.TimeUtil;
import com.alibaba.csp.sentinel.util.VersionUtil;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public class SystemAdaptiveThrottler {
    private static ThreadLocal<Random> randomThreadLocalForJdk6 = new ThreadLocal<Random>(){

        @Override
        public Random initialValue() {
            return new Random(TimeUtil.currentTimeMillis());
        }
    };
    private static volatile double passProbability;

    public static double getPassProbability() {
        return passProbability;
    }

    static void setPassProbability(double passProbability) {
        SystemAdaptiveThrottler.passProbability = passProbability;
    }

    public static boolean canPass() {
        if (VersionUtil.isJdk7OrHigher()) {
            return ThreadLocalRandom.current().nextDouble() < passProbability;
        }
        return randomThreadLocalForJdk6.get().nextDouble() < passProbability;
    }
}

