/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adaptive.pid;

public class PIDController {
    private double kp;
    private double ki;
    private double kd;
    private double sp;
    private double maxOutput = 2.0;
    private double minOutput = -1.5;
    private double integral;
    private double lastErr;
    private double lastOutput;
    private double emaAlpha = 0.2;

    public PIDController(double kp, double ki, double kd, double sp) {
        this.kp = kp;
        this.ki = ki;
        this.kd = kd;
        this.sp = sp;
    }

    public PIDController setOutputRange(double min, double max) {
        if (min <= max) {
            this.maxOutput = max;
            this.minOutput = min;
        }
        return this;
    }

    private double constrainWithin(double value, double lowerBound, double upperBound) {
        return Math.min(Math.max(value, lowerBound), upperBound);
    }

    private boolean inRange(double value, double lowerBound, double upperBound) {
        return value >= lowerBound && value <= upperBound;
    }

    private boolean inRangeExclusive(double value, double lowerBound, double upperBound) {
        return value > lowerBound && value < upperBound;
    }

    public double calcOutput(double actual, double sp) {
        double err = sp - actual;
        double outputP = this.kp * err;
        double errorDiff = err - this.lastErr;
        double outputD = this.ki * errorDiff;
        this.lastErr = err;
        if (this.inRange(this.lastOutput, this.minOutput, this.maxOutput)) {
            this.integral += err;
        } else if (this.lastOutput > this.maxOutput && err < 0.0 || this.lastOutput < this.maxOutput && err > 0.0) {
            this.integral += err;
        }
        double outputI = this.kd * this.integral;
        double output = outputP + outputI + outputD;
        if (this.emaAlpha > 0.0) {
            output = this.lastOutput * this.emaAlpha + output * (1.0 - this.emaAlpha);
        }
        this.lastOutput = output;
        return output;
    }

    public PIDController setEmaAlpha(double emaAlpha) {
        this.emaAlpha = emaAlpha;
        return this;
    }
}

