/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.annotation.aspectj;

import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SentinelWrapper;
import com.alibaba.csp.sentinel.annotation.SentinelResource;
import com.alibaba.csp.sentinel.annotation.aspectj.AbstractSentinelAspectSupport;
import com.alibaba.csp.sentinel.annotation.aspectj.SentinelAnnotationGlobalFallback;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class SentinelResourceAspect
extends AbstractSentinelAspectSupport {
    public SentinelResourceAspect() {
        this(null);
    }

    public SentinelResourceAspect(SentinelAnnotationGlobalFallback globalFallback) {
        super(globalFallback);
    }

    @Pointcut(value="@annotation(com.alibaba.csp.sentinel.annotation.SentinelResource)")
    public void sentinelResourceAnnotationPointcut() {
    }

    @Around(value="sentinelResourceAnnotationPointcut()")
    public Object invokeResourceWithSentinel(final ProceedingJoinPoint pjp) throws Throwable {
        Method originMethod = this.resolveMethod(pjp);
        SentinelResource annotation = originMethod.getAnnotation(SentinelResource.class);
        if (annotation == null) {
            throw new IllegalStateException("Wrong state for SentinelResource annotation");
        }
        String resourceName = SentinelResourceAspect.getResourceName(annotation.value(), originMethod);
        EntryType entryType = annotation.entryType();
        int resourceType = annotation.resourceType();
        try {
            return SentinelWrapper.execute(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    try {
                        return pjp.proceed();
                    }
                    catch (Exception e) {
                        throw e;
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        throw new RuntimeException(t);
                    }
                }
            }, resourceName, entryType, resourceType, pjp.getArgs());
        }
        catch (Throwable ex) {
            if (ex instanceof BlockException) {
                return this.handleBlockException(pjp, annotation, (BlockException)ex);
            }
            Class<? extends Throwable>[] exceptionsToIgnore = annotation.exceptionsToIgnore();
            if (exceptionsToIgnore.length > 0 && this.exceptionBelongsTo(ex, exceptionsToIgnore)) {
                throw ex;
            }
            if (this.exceptionBelongsTo(ex, annotation.exceptionsToTrace())) {
                return this.handleFallback(pjp, annotation, ex);
            }
            throw ex;
        }
    }
}

