/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.client;

import com.alibaba.csp.sentinel.cluster.ClusterTransportClient;
import com.alibaba.csp.sentinel.cluster.TokenResult;
import com.alibaba.csp.sentinel.cluster.TokenResultStatus;
import com.alibaba.csp.sentinel.cluster.TokenServerDescriptor;
import com.alibaba.csp.sentinel.cluster.client.ClusterTokenClient;
import com.alibaba.csp.sentinel.cluster.client.NettyTransportClient;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientAssignConfig;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientConfigManager;
import com.alibaba.csp.sentinel.cluster.client.config.ServerChangeObserver;
import com.alibaba.csp.sentinel.cluster.common.SyncTokenRequest;
import com.alibaba.csp.sentinel.cluster.log.ClusterClientStatLogUtil;
import com.alibaba.csp.sentinel.cluster.request.ClusterRequest;
import com.alibaba.csp.sentinel.cluster.request.data.FlowRequestData;
import com.alibaba.csp.sentinel.cluster.request.data.ParamFlowRequestData;
import com.alibaba.csp.sentinel.cluster.response.ClusterResponse;
import com.alibaba.csp.sentinel.cluster.response.data.FlowTokenResponseData;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.node.ResourceNodeStorage;
import com.alibaba.csp.sentinel.util.CollectionUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.csp.sentinel.util.TimeUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class DefaultClusterTokenClient
implements ClusterTokenClient {
    private ClusterTransportClient transportClient;
    private TokenServerDescriptor serverDescriptor;
    private final AtomicBoolean shouldStart = new AtomicBoolean(false);

    public DefaultClusterTokenClient() {
        ClusterClientConfigManager.addServerChangeObserver(new ServerChangeObserver(){

            @Override
            public void onRemoteServerChange(ClusterClientAssignConfig assignConfig) {
                DefaultClusterTokenClient.this.changeServer(assignConfig);
            }
        });
        this.initNewConnection();
    }

    private boolean serverEqual(TokenServerDescriptor descriptor, ClusterClientAssignConfig config) {
        if (descriptor == null || config == null) {
            return false;
        }
        return descriptor.getHost().equals(config.getServerHost()) && descriptor.getPort() == config.getServerPort().intValue();
    }

    private void initNewConnection() {
        if (this.transportClient != null) {
            return;
        }
        String host = ClusterClientConfigManager.getServerHost();
        int port = ClusterClientConfigManager.getServerPort();
        if (StringUtil.isBlank(host) || port <= 0) {
            return;
        }
        try {
            this.transportClient = new NettyTransportClient(host, port);
            this.serverDescriptor = new TokenServerDescriptor(host, port);
            RecordLog.info("[DefaultClusterTokenClient] New client created: " + this.serverDescriptor, new Object[0]);
        }
        catch (Exception ex) {
            RecordLog.warn("[DefaultClusterTokenClient] Failed to initialize new token client", ex);
        }
    }

    private void changeServer(ClusterClientAssignConfig config) {
        if (this.serverEqual(this.serverDescriptor, config)) {
            return;
        }
        try {
            if (this.transportClient != null) {
                this.transportClient.stop();
            }
            this.transportClient = new NettyTransportClient(config.getServerHost(), config.getServerPort());
            this.serverDescriptor = new TokenServerDescriptor(config.getServerHost(), config.getServerPort());
            this.startClientIfScheduled();
            RecordLog.info("[DefaultClusterTokenClient] New client created: " + this.serverDescriptor, new Object[0]);
        }
        catch (Exception ex) {
            RecordLog.warn("[DefaultClusterTokenClient] Failed to change remote token server", ex);
        }
    }

    private void startClientIfScheduled() throws Exception {
        if (this.shouldStart.get()) {
            if (this.transportClient != null) {
                this.transportClient.start();
            } else {
                RecordLog.warn("[DefaultClusterTokenClient] Cannot start transport client: client not created", new Object[0]);
            }
        }
    }

    private void stopClientIfStarted() throws Exception {
        if (this.shouldStart.compareAndSet(true, false) && this.transportClient != null) {
            this.transportClient.stop();
        }
    }

    @Override
    public void start() throws Exception {
        if (this.shouldStart.compareAndSet(false, true)) {
            this.startClientIfScheduled();
        }
    }

    @Override
    public void stop() throws Exception {
        this.stopClientIfStarted();
    }

    @Override
    public int getState() {
        if (this.transportClient == null) {
            return 0;
        }
        return this.transportClient.isReady() ? 2 : 0;
    }

    @Override
    public TokenServerDescriptor currentServer() {
        return this.serverDescriptor;
    }

    @Override
    public TokenResult requestToken(Long flowId, int acquireCount, boolean prioritized, boolean allowPartialAcq) {
        if (this.notValidRequest(flowId, acquireCount) || acquireCount == 0) {
            return this.badRequest();
        }
        FlowRequestData data = new FlowRequestData().setCount(acquireCount).setFlowId(flowId).setPrioritized(prioritized).setAllowPartialAcq(allowPartialAcq);
        ClusterRequest<FlowRequestData> request = new ClusterRequest<FlowRequestData>(1, data);
        try {
            TokenResult result = this.sendTokenRequest(request);
            return result;
        }
        catch (Exception ex) {
            ClusterClientStatLogUtil.log(ex.getMessage());
            return new TokenResult(-1).setError(ex);
        }
    }

    @Override
    public TokenResult requestParamToken(Long flowId, int acquireCount, Collection<Object> params) {
        if (this.notValidRequest(flowId, acquireCount) || acquireCount == 0 || CollectionUtil.isEmpty(params)) {
            return this.badRequest();
        }
        ParamFlowRequestData data = new ParamFlowRequestData().setCount(acquireCount).setFlowId(flowId).setParams(params);
        ClusterRequest<ParamFlowRequestData> request = new ClusterRequest<ParamFlowRequestData>(2, data);
        try {
            TokenResult result = this.sendTokenRequest(request);
            this.logForResult(result);
            return result;
        }
        catch (Exception ex) {
            ClusterClientStatLogUtil.log(ex.getMessage());
            return new TokenResult(-1);
        }
    }

    @Override
    public TokenResult syncToken(SyncTokenRequest request, int timeoutMs) {
        if (this.notValidRequest(request.getRuleId(), request.getBatchCount()) || request.getCurMillis() == null) {
            return this.badRequest();
        }
        ClusterRequest<SyncTokenRequest> cr = new ClusterRequest<SyncTokenRequest>(5, request);
        try {
            TokenResult result = this.sendTokenRequest(cr, timeoutMs);
            this.logForResult(result);
            return result;
        }
        catch (Exception ex) {
            ClusterClientStatLogUtil.log(ex.getMessage());
            return new TokenResult(-1);
        }
    }

    private void logForResult(TokenResult result) {
        switch (result.getStatus()) {
            case -3: 
            case -2: 
            case 3: {
                ClusterClientStatLogUtil.log(TokenResultStatus.toStatusString(result.getStatus()));
                break;
            }
        }
    }

    private TokenResult sendTokenRequest(ClusterRequest request) throws Exception {
        return this.sendTokenRequest(request, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TokenResult sendTokenRequest(ClusterRequest request, int timeoutMs) throws Exception {
        if (this.transportClient == null) {
            RecordLog.warn("[DefaultClusterTokenClient] Client not created, please check your config for cluster client", new Object[0]);
            return this.clientFail();
        }
        long startTime = TimeUtil.currentTimeMillis();
        try {
            this.recordTransportStart();
            ClusterResponse response = this.transportClient.sendRequest(request, timeoutMs);
            TokenResult result = new TokenResult(response.getStatus());
            if (response.getData() != null) {
                FlowTokenResponseData responseData = (FlowTokenResponseData)response.getData();
                result.setRemaining(responseData.getRemainingCount()).setAttachments(this.generateAttachmentMap(responseData)).setWaitInMs(responseData.getWaitInMs());
            }
            TokenResult tokenResult = result;
            return tokenResult;
        }
        finally {
            long rtt = TimeUtil.currentTimeMillis() - startTime;
            this.recordTransportComplete(rtt);
        }
    }

    private void recordTransportComplete(long rtt) {
        ResourceNodeStorage.CLUSTER_FLOW_TRANSPORT_STAT_NODE.addRtAndSuccess(rtt, 1);
    }

    private void recordTransportStart() {
        ResourceNodeStorage.CLUSTER_FLOW_TRANSPORT_STAT_NODE.addPassRequest(1);
    }

    private Map<String, Object> generateAttachmentMap(FlowTokenResponseData responseData) {
        if (responseData.getBucketStart() == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("bucketStartOfServer", responseData.getBucketStart());
        return map;
    }

    private boolean isValidId(Long id) {
        return id != null && id > 0L;
    }

    private boolean notValidRequest(Long id, Integer count) {
        return !this.isValidId(id) || count == null || count < 0;
    }

    private TokenResult badRequest() {
        return new TokenResult(-4);
    }

    private TokenResult clientFail() {
        return new TokenResult(-1);
    }
}

