/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.client;

import com.alibaba.csp.ahas.shaded.io.netty.bootstrap.Bootstrap;
import com.alibaba.csp.ahas.shaded.io.netty.buffer.PooledByteBufAllocator;
import com.alibaba.csp.ahas.shaded.io.netty.channel.Channel;
import com.alibaba.csp.ahas.shaded.io.netty.channel.ChannelFuture;
import com.alibaba.csp.ahas.shaded.io.netty.channel.ChannelInitializer;
import com.alibaba.csp.ahas.shaded.io.netty.channel.ChannelOption;
import com.alibaba.csp.ahas.shaded.io.netty.channel.ChannelPipeline;
import com.alibaba.csp.ahas.shaded.io.netty.channel.ChannelPromise;
import com.alibaba.csp.ahas.shaded.io.netty.channel.nio.NioEventLoopGroup;
import com.alibaba.csp.ahas.shaded.io.netty.channel.socket.SocketChannel;
import com.alibaba.csp.ahas.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import com.alibaba.csp.ahas.shaded.io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import com.alibaba.csp.ahas.shaded.io.netty.handler.codec.LengthFieldPrepender;
import com.alibaba.csp.ahas.shaded.io.netty.handler.timeout.IdleStateHandler;
import com.alibaba.csp.ahas.shaded.io.netty.util.concurrent.Future;
import com.alibaba.csp.ahas.shaded.io.netty.util.concurrent.GenericFutureListener;
import com.alibaba.csp.sentinel.cluster.ClusterTransportClient;
import com.alibaba.csp.sentinel.cluster.client.codec.netty.NettyRequestEncoder;
import com.alibaba.csp.sentinel.cluster.client.codec.netty.NettyResponseDecoder;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientConfigManager;
import com.alibaba.csp.sentinel.cluster.client.handler.TokenClientHandler;
import com.alibaba.csp.sentinel.cluster.client.handler.TokenClientPromiseHolder;
import com.alibaba.csp.sentinel.cluster.exception.SentinelClusterException;
import com.alibaba.csp.sentinel.cluster.request.ClusterRequest;
import com.alibaba.csp.sentinel.cluster.request.Request;
import com.alibaba.csp.sentinel.cluster.response.ClusterResponse;
import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.AssertUtil;
import java.util.AbstractMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class NettyTransportClient
implements ClusterTransportClient {
    private static final ScheduledExecutorService SCHEDULER = Executors.newScheduledThreadPool(1, new NamedThreadFactory("sentinel-cluster-transport-client-scheduler"));
    public static final int RECONNECT_DELAY_MS = 2000;
    private final String host;
    private final int port;
    private final boolean tlsEnabled = true;
    private Channel channel;
    private NioEventLoopGroup eventLoopGroup;
    private TokenClientHandler clientHandler;
    private final AtomicInteger idGenerator = new AtomicInteger(0);
    private final AtomicInteger currentState = new AtomicInteger(0);
    private final AtomicInteger failConnectedTime = new AtomicInteger(0);
    private final AtomicBoolean shouldRetry = new AtomicBoolean(true);
    private Runnable disconnectCallback = new Runnable(){

        @Override
        public void run() {
            if (!NettyTransportClient.this.shouldRetry.get()) {
                return;
            }
            SCHEDULER.schedule(new Runnable(){

                @Override
                public void run() {
                    if (NettyTransportClient.this.shouldRetry.get()) {
                        RecordLog.info("[NettyTransportClient] Reconnecting to server <" + NettyTransportClient.this.host + ":" + NettyTransportClient.this.port + ">", new Object[0]);
                        try {
                            NettyTransportClient.this.startInternal();
                        }
                        catch (Exception e) {
                            RecordLog.warn("[NettyTransportClient] Failed to reconnect to server", e);
                        }
                    }
                }
            }, 2000L * (long)(NettyTransportClient.this.failConnectedTime.get() + 1), TimeUnit.MILLISECONDS);
            NettyTransportClient.this.cleanUp();
        }
    };
    private static final int MAX_ID = 999999999;

    public NettyTransportClient(String host, int port) {
        AssertUtil.assertNotBlank(host, "remote host cannot be blank");
        AssertUtil.isTrue(port > 0, "port should be positive");
        this.host = host;
        this.port = port;
    }

    private Bootstrap initClientBootstrap() {
        Bootstrap b = new Bootstrap();
        this.eventLoopGroup = new NioEventLoopGroup();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)b.group(this.eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, true)).option(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, ClusterClientConfigManager.getConnectTimeout())).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            public void initChannel(SocketChannel ch) throws Exception {
                NettyTransportClient.this.clientHandler = new TokenClientHandler(NettyTransportClient.this.currentState, NettyTransportClient.this.disconnectCallback);
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new IdleStateHandler(0, 30, 0));
                pipeline.addLast(new LengthFieldBasedFrameDecoder(1024, 0, 2, 0, 2));
                pipeline.addLast(new NettyResponseDecoder());
                pipeline.addLast(new LengthFieldPrepender(2));
                pipeline.addLast(new NettyRequestEncoder());
                pipeline.addLast(NettyTransportClient.this.clientHandler);
            }
        });
        return b;
    }

    private void connect(Bootstrap b) {
        try {
            if (this.currentState.compareAndSet(0, 1)) {
                b.connect(this.host, this.port).addListener((GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<ChannelFuture>(){

                    @Override
                    public void operationComplete(ChannelFuture future) {
                        if (future.cause() != null) {
                            RecordLog.warn(String.format("[NettyTransportClient] Could not connect to <%s:%d> after %d times", NettyTransportClient.this.host, NettyTransportClient.this.port, NettyTransportClient.this.failConnectedTime.get()), future.cause());
                            NettyTransportClient.this.failConnectedTime.incrementAndGet();
                            NettyTransportClient.this.channel = null;
                        } else {
                            NettyTransportClient.this.failConnectedTime.set(0);
                            NettyTransportClient.this.channel = future.channel();
                            RecordLog.info("[NettyTransportClient] Successfully connect to server <" + NettyTransportClient.this.host + ":" + NettyTransportClient.this.port + ">", new Object[0]);
                        }
                    }
                });
            }
        }
        catch (Throwable t) {
            this.currentState.set(0);
            RecordLog.warn("Fatal error when connecting server in token client", t);
        }
    }

    @Override
    public void start() throws Exception {
        this.shouldRetry.set(true);
        this.startInternal();
    }

    private void startInternal() {
        this.connect(this.initClientBootstrap());
    }

    private void cleanUp() {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
        if (this.eventLoopGroup != null) {
            this.eventLoopGroup.shutdownGracefully();
        }
    }

    @Override
    public void stop() throws Exception {
        this.shouldRetry.set(false);
        for (int slept = 0; this.currentState.get() == 1 && slept < 2000; slept += 200) {
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
                break;
            }
        }
        this.cleanUp();
        this.failConnectedTime.set(0);
        RecordLog.info("[NettyTransportClient] Cluster transport client stopped", new Object[0]);
    }

    private boolean validRequest(Request request) {
        return request != null && request.getType() >= 0;
    }

    @Override
    public boolean isReady() {
        return this.channel != null && this.clientHandler != null && this.clientHandler.hasStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClusterResponse sendRequest(ClusterRequest request, int timeoutMs) throws Exception {
        if (!this.isReady()) {
            throw new SentinelClusterException("client not ready");
        }
        if (!this.validRequest(request)) {
            throw new SentinelClusterException("bad request");
        }
        int xid = this.getCurrentId();
        try {
            int requestTimeout;
            request.setId(xid);
            this.channel.writeAndFlush(request);
            ChannelPromise promise = this.channel.newPromise();
            TokenClientPromiseHolder.putPromise(xid, promise);
            int n = requestTimeout = timeoutMs > 0 ? timeoutMs : ClusterClientConfigManager.getRequestTimeout();
            if (!promise.await(requestTimeout)) {
                throw new SentinelClusterException("request timeout", -102);
            }
            AbstractMap.SimpleEntry<ChannelPromise, ClusterResponse> entry = TokenClientPromiseHolder.getEntry(xid);
            if (entry == null || entry.getValue() == null) {
                throw new SentinelClusterException("unexpected status");
            }
            ClusterResponse clusterResponse = entry.getValue();
            return clusterResponse;
        }
        finally {
            TokenClientPromiseHolder.remove(xid);
        }
    }

    private int getCurrentId() {
        if (this.idGenerator.get() > 999999999) {
            this.idGenerator.set(0);
        }
        return this.idGenerator.incrementAndGet();
    }
}

