/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.client.auth.ssl;

import com.alibaba.csp.sentinel.util.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;

public class CertStorage {
    public static final String CLIENT_CERT_PATH = "/tmp/cChat.jks";
    private static Map<String, String> ossClientAddress = new HashMap<String, String>();

    public static void createOrUpdateClientCert(String regionId, String env) {
        if (StringUtil.isBlank(regionId)) {
            throw new IllegalArgumentException("regionId cannot be empty");
        }
        if (StringUtil.isBlank(env)) {
            throw new IllegalArgumentException("env cannot be empty");
        }
        String key = env + "-" + regionId;
        String ossAddress = ossClientAddress.get(key);
        if (StringUtil.isBlank(ossAddress)) {
            throw new IllegalArgumentException("region or env not supported: " + key);
        }
        CertStorage.downloadFromOss(CLIENT_CERT_PATH, ossAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downloadFromOss(String filePath, String ossAddress) {
        FileOutputStream out = null;
        InputStream in = null;
        try {
            URL url = new URL(ossAddress);
            URLConnection urlConnection = url.openConnection();
            HttpURLConnection connection = (HttpURLConnection)urlConnection;
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setRequestProperty("Content-type", "application/x-java-serialized-object");
            connection.setRequestMethod("GET");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("Charsert", "UTF-8");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(60000);
            connection.connect();
            in = connection.getInputStream();
            File file = new File(filePath);
            File fileParent = file.getParentFile();
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            out = new FileOutputStream(file);
            byte[] buffer = new byte[4096];
            int readLength = 0;
            while ((readLength = in.read(buffer)) > 0) {
                byte[] bytes = new byte[readLength];
                System.arraycopy(buffer, 0, bytes, 0, readLength);
                out.write(bytes);
            }
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private CertStorage() {
    }

    static {
        ossClientAddress.put("pre-cn-public", "https://ahas-cn-public.oss-cn-hangzhou.aliyuncs.com/agent/pre/cert/cChat.jks");
        ossClientAddress.put("prod-cn-public", "https://ahasoss-cn-public.oss-cn-hangzhou.aliyuncs.com/agent/prod/cert/cChat.jks");
        ossClientAddress.put("pre-cn-hangzhou", "https://ahas-cn-hangzhou.oss-cn-hangzhou-internal.aliyuncs.com/agent/pre/cert/cChat.jks");
        ossClientAddress.put("prod-cn-hangzhou", "https://ahasoss-cn-hangzhou.oss-cn-hangzhou-internal.aliyuncs.com/agent/prod/cert/cChat.jks");
        ossClientAddress.put("prod-cn-beijing", "https://ahasoss-cn-beijing.oss-cn-beijing-internal.aliyuncs.com/agent/prod/cert/cChat.jks");
        ossClientAddress.put("prod-cn-shanghai", "https://ahasoss-cn-shanghai.oss-cn-shanghai-internal.aliyuncs.com/agent/prod/cert/cChat.jks");
        ossClientAddress.put("prod-cn-shenzhen", "https://ahasoss-cn-shenzhen.oss-cn-shenzhen-internal.aliyuncs.com/agent/prod/cert/cChat.jks");
        ossClientAddress.put("prod-cn-zhangjiakou", "https://ahasoss-cn-zhangjiakou.oss-cn-zhangjiakou.aliyuncs.com/agent/prod/cert/cChat.jks");
        ossClientAddress.put("prod-cn-shanghai-finance-1", "http://ahasoss-cn-financial.oss-cn-shanghai-finance-1-internal.aliyuncs.com/agent/prod/cert/cChat.jks");
        ossClientAddress.put("prod-cn-north-2-gov-1", "https://ahasoss-cn-north-2-gov-1.oss-cn-north-2-gov-1-internal.aliyuncs.com/agent/prod/cert/cChat.jks");
    }
}

