/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.client.codec;

import com.alibaba.csp.ahas.shaded.io.netty.buffer.ByteBuf;
import com.alibaba.csp.sentinel.cluster.client.codec.registry.ResponseDataDecodeRegistry;
import com.alibaba.csp.sentinel.cluster.codec.EntityDecoder;
import com.alibaba.csp.sentinel.cluster.codec.response.ResponseEntityDecoder;
import com.alibaba.csp.sentinel.cluster.response.ClusterResponse;
import com.alibaba.csp.sentinel.log.RecordLog;

public class DefaultResponseEntityDecoder
implements ResponseEntityDecoder<ByteBuf, ClusterResponse> {
    @Override
    public ClusterResponse decode(ByteBuf source) {
        if (source.readableBytes() >= 6) {
            int xid = source.readInt();
            byte type = source.readByte();
            byte status = source.readByte();
            EntityDecoder<ByteBuf, Object> decoder = ResponseDataDecodeRegistry.getDecoder(type);
            if (decoder == null) {
                RecordLog.warn("Unknown type of response data decoder: {}", type);
                return null;
            }
            Object data = source.readableBytes() == 0 ? null : decoder.decode(source);
            return new ClusterResponse<Object>(xid, type, status, data);
        }
        return null;
    }
}

