/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.client.codec.data;

import com.alibaba.csp.ahas.shaded.io.netty.buffer.ByteBuf;
import com.alibaba.csp.sentinel.cluster.codec.EntityWriter;
import com.alibaba.csp.sentinel.cluster.request.data.ConnectRequestData;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.Map;

public class ConnectRequestDataWriter
implements EntityWriter<ConnectRequestData, ByteBuf> {
    @Override
    public void writeTo(ConnectRequestData entity, ByteBuf target) {
        if (entity == null || target == null || StringUtil.isBlank(entity.getNamespace())) {
            return;
        }
        this.writeString(entity.getNamespace(), target);
        Map<String, String> credentials = entity.getCredentials();
        int size = credentials == null ? 0 : credentials.size();
        target.writeInt(size);
        if (size > 0) {
            for (Map.Entry<String, String> e : credentials.entrySet()) {
                this.writeString(e.getKey(), target);
                this.writeString(e.getValue(), target);
            }
        }
    }

    private void writeString(String str, ByteBuf target) {
        byte[] strBytes = str.getBytes();
        int len = strBytes.length;
        target.writeInt(len);
        if (len > 0) {
            target.writeBytes(strBytes);
        }
    }
}

