/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.client.codec.data;

import com.alibaba.csp.ahas.shaded.io.netty.buffer.ByteBuf;
import com.alibaba.csp.sentinel.cluster.codec.EntityDecoder;
import com.alibaba.csp.sentinel.cluster.response.data.ConnectResponseData;

public class ConnectResponseDataDecoder
implements EntityDecoder<ByteBuf, ConnectResponseData> {
    @Override
    public ConnectResponseData decode(ByteBuf source) {
        ConnectResponseData data = new ConnectResponseData();
        int readableBytes = source.readableBytes();
        if (readableBytes == 1) {
            data.setConnectedCount(source.readByte());
            return data;
        }
        if (readableBytes >= 4) {
            data.setConnectedCount(source.readInt());
            if (source.readableBytes() > 0) {
                data.setMessage(this.readString(source));
            }
        }
        return data;
    }

    private String readString(ByteBuf source) {
        int len = source.readInt();
        if (len <= 0) {
            return null;
        }
        byte[] bytes = new byte[len];
        source.readBytes(bytes);
        return new String(bytes);
    }
}

