/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.client.config;

import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientAssignConfig;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientConfig;
import com.alibaba.csp.sentinel.cluster.client.config.ServerChangeObserver;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.property.DynamicSentinelProperty;
import com.alibaba.csp.sentinel.property.PropertyListener;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public final class ClusterClientConfigManager {
    private static volatile String serverHost = null;
    private static volatile int serverPort = 18730;
    private static volatile int requestTimeout = 20;
    private static volatile int connectTimeout = 10000;
    private static final PropertyListener<ClusterClientConfig> CONFIG_PROPERTY_LISTENER = new ClientConfigPropertyListener();
    private static final PropertyListener<ClusterClientAssignConfig> ASSIGN_PROPERTY_LISTENER = new ClientAssignPropertyListener();
    private static SentinelProperty<ClusterClientConfig> clientConfigProperty = new DynamicSentinelProperty<ClusterClientConfig>();
    private static SentinelProperty<ClusterClientAssignConfig> clientAssignProperty = new DynamicSentinelProperty<ClusterClientAssignConfig>();
    private static final List<ServerChangeObserver> SERVER_CHANGE_OBSERVERS = new ArrayList<ServerChangeObserver>();

    private static void bindPropertyListener() {
        ClusterClientConfigManager.removePropertyListener();
        clientAssignProperty.addListener(ASSIGN_PROPERTY_LISTENER);
        clientConfigProperty.addListener(CONFIG_PROPERTY_LISTENER);
    }

    private static void removePropertyListener() {
        clientAssignProperty.removeListener(ASSIGN_PROPERTY_LISTENER);
        clientConfigProperty.removeListener(CONFIG_PROPERTY_LISTENER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerServerAssignProperty(SentinelProperty<ClusterClientAssignConfig> property) {
        AssertUtil.notNull(property, "property cannot be null");
        PropertyListener<ClusterClientAssignConfig> propertyListener = ASSIGN_PROPERTY_LISTENER;
        synchronized (propertyListener) {
            RecordLog.info("[ClusterClientConfigManager] Registering new server assignment property to cluster client config manager", new Object[0]);
            clientAssignProperty.removeListener(ASSIGN_PROPERTY_LISTENER);
            property.addListener(ASSIGN_PROPERTY_LISTENER);
            clientAssignProperty = property;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerClientConfigProperty(SentinelProperty<ClusterClientConfig> property) {
        AssertUtil.notNull(property, "property cannot be null");
        PropertyListener<ClusterClientConfig> propertyListener = CONFIG_PROPERTY_LISTENER;
        synchronized (propertyListener) {
            RecordLog.info("[ClusterClientConfigManager] Registering new global client config property to cluster client config manager", new Object[0]);
            clientConfigProperty.removeListener(CONFIG_PROPERTY_LISTENER);
            property.addListener(CONFIG_PROPERTY_LISTENER);
            clientConfigProperty = property;
        }
    }

    public static void addServerChangeObserver(ServerChangeObserver observer) {
        AssertUtil.notNull(observer, "observer cannot be null");
        SERVER_CHANGE_OBSERVERS.add(observer);
    }

    public static void applyNewConfig(ClusterClientConfig config) {
        clientConfigProperty.updateValue(config);
    }

    public static void applyNewAssignConfig(ClusterClientAssignConfig clusterClientAssignConfig) {
        clientAssignProperty.updateValue(clusterClientAssignConfig);
    }

    private static void updateClientConfigChange(ClusterClientConfig config) {
        if (config.getRequestTimeout() != requestTimeout) {
            requestTimeout = config.getRequestTimeout();
        }
    }

    private static void updateServerAssignment(ClusterClientAssignConfig config) {
        String host = config.getServerHost();
        int port = config.getServerPort();
        for (ServerChangeObserver observer : SERVER_CHANGE_OBSERVERS) {
            observer.onRemoteServerChange(config);
        }
        serverHost = host;
        serverPort = port;
    }

    public static boolean isValidAssignConfig(ClusterClientAssignConfig config) {
        return config != null && StringUtil.isNotBlank(config.getServerHost()) && config.getServerPort() > 0 && config.getServerPort() <= 65535;
    }

    public static boolean isValidClientConfig(ClusterClientConfig config) {
        return config != null && config.getRequestTimeout() > 0;
    }

    public static String getServerHost() {
        return serverHost;
    }

    public static int getServerPort() {
        return serverPort;
    }

    public static int getRequestTimeout() {
        return requestTimeout;
    }

    public static int getConnectTimeout() {
        return connectTimeout;
    }

    private ClusterClientConfigManager() {
    }

    static {
        ClusterClientConfigManager.bindPropertyListener();
    }

    private static class ClientConfigPropertyListener
    implements PropertyListener<ClusterClientConfig> {
        private ClientConfigPropertyListener() {
        }

        @Override
        public void configLoad(ClusterClientConfig config) {
            if (config == null) {
                RecordLog.warn("[ClusterClientConfigManager] Empty initial client config", new Object[0]);
                return;
            }
            this.applyConfig(config);
        }

        @Override
        public void configUpdate(ClusterClientConfig config) {
            this.applyConfig(config);
        }

        private synchronized void applyConfig(ClusterClientConfig config) {
            if (!ClusterClientConfigManager.isValidClientConfig(config)) {
                RecordLog.warn("[ClusterClientConfigManager] Invalid cluster client config, ignoring: " + config, new Object[0]);
                return;
            }
            RecordLog.info("[ClusterClientConfigManager] Updating to new client config: " + config, new Object[0]);
            ClusterClientConfigManager.updateClientConfigChange(config);
        }
    }

    private static class ClientAssignPropertyListener
    implements PropertyListener<ClusterClientAssignConfig> {
        private ClientAssignPropertyListener() {
        }

        @Override
        public void configLoad(ClusterClientAssignConfig config) {
            if (config == null) {
                RecordLog.warn("[ClusterClientConfigManager] Empty initial client assignment config", new Object[0]);
                return;
            }
            this.applyConfig(config);
        }

        @Override
        public void configUpdate(ClusterClientAssignConfig config) {
            this.applyConfig(config);
        }

        private synchronized void applyConfig(ClusterClientAssignConfig config) {
            if (!ClusterClientConfigManager.isValidAssignConfig(config)) {
                RecordLog.warn("[ClusterClientConfigManager] Invalid cluster client assign config, ignoring: " + config, new Object[0]);
                return;
            }
            if (serverPort == config.getServerPort() && config.getServerHost().equals(serverHost)) {
                return;
            }
            RecordLog.info("[ClusterClientConfigManager] Assign to new target token server: " + config, new Object[0]);
            ClusterClientConfigManager.updateServerAssignment(config);
        }
    }
}

