/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.client.handler;

import com.alibaba.csp.ahas.shaded.io.netty.channel.ChannelPromise;
import com.alibaba.csp.sentinel.cluster.response.ClusterResponse;
import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class TokenClientPromiseHolder {
    private static final Map<Integer, AbstractMap.SimpleEntry<ChannelPromise, ClusterResponse>> PROMISE_MAP = new ConcurrentHashMap<Integer, AbstractMap.SimpleEntry<ChannelPromise, ClusterResponse>>();

    public static void putPromise(int xid, ChannelPromise promise) {
        PROMISE_MAP.put(xid, new AbstractMap.SimpleEntry<ChannelPromise, Object>(promise, null));
    }

    public static AbstractMap.SimpleEntry<ChannelPromise, ClusterResponse> getEntry(int xid) {
        return PROMISE_MAP.get(xid);
    }

    public static void remove(int xid) {
        PROMISE_MAP.remove(xid);
    }

    public static <T> boolean completePromise(int xid, ClusterResponse<T> response) {
        if (!PROMISE_MAP.containsKey(xid)) {
            return false;
        }
        AbstractMap.SimpleEntry<ChannelPromise, ClusterResponse> entry = PROMISE_MAP.get(xid);
        if (entry != null) {
            ChannelPromise promise = entry.getKey();
            if (promise.isDone() || promise.isCancelled()) {
                return false;
            }
            entry.setValue(response);
            promise.setSuccess();
            return true;
        }
        return false;
    }

    private TokenClientPromiseHolder() {
    }
}

