/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.client.init;

import com.alibaba.csp.ahas.shaded.io.netty.buffer.ByteBuf;
import com.alibaba.csp.sentinel.cluster.client.codec.data.ConnectRequestDataWriter;
import com.alibaba.csp.sentinel.cluster.client.codec.data.ConnectResponseDataDecoder;
import com.alibaba.csp.sentinel.cluster.client.codec.data.FlowRequestDataWriter;
import com.alibaba.csp.sentinel.cluster.client.codec.data.FlowResponseDataDecoder;
import com.alibaba.csp.sentinel.cluster.client.codec.data.ParamFlowRequestDataWriter;
import com.alibaba.csp.sentinel.cluster.client.codec.data.SyncTokenRequestDataWriter;
import com.alibaba.csp.sentinel.cluster.client.codec.registry.RequestDataWriterRegistry;
import com.alibaba.csp.sentinel.cluster.client.codec.registry.ResponseDataDecodeRegistry;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientStartUpConfig;
import com.alibaba.csp.sentinel.cluster.codec.EntityWriter;
import com.alibaba.csp.sentinel.init.InitFunc;
import com.alibaba.csp.sentinel.init.InitOrder;

@InitOrder(value=0)
public class DefaultClusterClientInitFunc
implements InitFunc {
    @Override
    public void init() throws Exception {
        this.initDefaultEntityWriters();
        this.initDefaultEntityDecoders();
    }

    private void initDefaultEntityWriters() {
        RequestDataWriterRegistry.addWriter(0, new ConnectRequestDataWriter());
        RequestDataWriterRegistry.addWriter(1, new FlowRequestDataWriter());
        Integer maxParamByteSize = ClusterClientStartUpConfig.getMaxParamByteSize();
        if (maxParamByteSize == null) {
            RequestDataWriterRegistry.addWriter(2, new ParamFlowRequestDataWriter());
        } else {
            RequestDataWriterRegistry.addWriter(2, new ParamFlowRequestDataWriter(maxParamByteSize));
        }
        RequestDataWriterRegistry.addWriter(100, new EntityWriter<Object, ByteBuf>(){

            @Override
            public void writeTo(Object entity, ByteBuf target) {
            }
        });
        RequestDataWriterRegistry.addWriter(5, new SyncTokenRequestDataWriter());
    }

    private void initDefaultEntityDecoders() {
        ResponseDataDecodeRegistry.addDecoder(0, new ConnectResponseDataDecoder());
        ResponseDataDecodeRegistry.addDecoder(1, new FlowResponseDataDecoder());
        ResponseDataDecodeRegistry.addDecoder(2, new FlowResponseDataDecoder());
        ResponseDataDecodeRegistry.addDecoder(5, new FlowResponseDataDecoder());
    }
}

