/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.client.util;

import com.alibaba.csp.ahas.shaded.io.netty.buffer.ByteBuf;
import com.alibaba.csp.ahas.shaded.io.netty.channel.ChannelHandlerContext;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.net.InetSocketAddress;

public final class NettyUtils {
    public static final int DEFAULT_STRING_MAX_LEN = 10240;
    public static final int BYTE_SIZE = 1;
    public static final int INT_SIZE = 4;
    public static final int LONG_SIZE = 8;

    public static String getRemoteAddress(ChannelHandlerContext ctx) {
        if (ctx.channel().remoteAddress() == null) {
            return null;
        }
        InetSocketAddress inetAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        return inetAddress.getAddress().getHostAddress() + ":" + inetAddress.getPort();
    }

    public static String readString(ByteBuf buf, int len) {
        if (len <= 0) {
            return null;
        }
        if (len > 10240) {
            len = 10240;
        }
        byte[] bytes = new byte[len];
        buf.readBytes(bytes);
        return new String(bytes);
    }

    public static void writeString(String str, ByteBuf target) {
        if (StringUtil.isEmpty(str)) {
            return;
        }
        byte[] strBytes = str.getBytes();
        int len = strBytes.length;
        target.writeInt(len);
        if (len > 0) {
            target.writeBytes(strBytes);
        }
    }

    private NettyUtils() {
    }
}

