/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.metrics;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ClusterMetric {
    private static volatile ClusterMetric clusterMetric;
    private final Map<String, Map<String, Integer>> tokenTypeMetrics = new ConcurrentHashMap<String, Map<String, Integer>>();
    private final Map<String, Map<Integer, Integer>> tokenTimeMetrics = new ConcurrentHashMap<String, Map<Integer, Integer>>();

    private ClusterMetric() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClusterMetric getInstance() {
        if (clusterMetric != null) return clusterMetric;
        Class<ClusterMetric> clazz = ClusterMetric.class;
        synchronized (ClusterMetric.class) {
            if (clusterMetric != null) return clusterMetric;
            clusterMetric = new ClusterMetric();
            // ** MonitorExit[var0] (shouldn't be in output)
            return clusterMetric;
        }
    }

    public void tokenStatusMetrics(String ruleName, long time, String type) {
        Integer num;
        String toKey = ruleName + "_" + time;
        Map<String, Integer> timeStatistics = this.tokenTypeMetrics.get(toKey);
        if (timeStatistics == null) {
            timeStatistics = new ConcurrentHashMap<String, Integer>();
        }
        if ((num = timeStatistics.get(type)) == null) {
            num = 0;
        }
        num = num + 1;
        timeStatistics.put(type, num);
        this.tokenTypeMetrics.put(toKey, timeStatistics);
    }

    public void tokenTimeMetrics(String ruleName, long time, Integer cost) {
        Integer num;
        String toKey = ruleName + "_" + time;
        Map<Integer, Integer> timeStatistics = this.tokenTimeMetrics.get(toKey);
        if (timeStatistics == null) {
            timeStatistics = new ConcurrentHashMap<Integer, Integer>();
        }
        if ((num = timeStatistics.get(cost)) == null) {
            num = 0;
        }
        num = num + 1;
        timeStatistics.put(cost, num);
        this.tokenTimeMetrics.put(toKey, timeStatistics);
    }

    public Set<String> getKeys() {
        return this.tokenTimeMetrics.keySet();
    }

    public Map<Integer, Integer> getTokenTimeMetrics(String key) {
        HashMap res = this.tokenTimeMetrics.get(key);
        return res == null ? new HashMap() : res;
    }

    public Map<String, Integer> getTokenStatusMetrics(String key) {
        HashMap res = this.tokenTypeMetrics.get(key);
        return res == null ? new HashMap() : res;
    }

    public String getTokenStatistics(String resource, long time) {
        String toKey = resource + "_" + time;
        StringBuilder builder = new StringBuilder();
        Map<Integer, Integer> times = this.tokenTimeMetrics.get(toKey);
        if (times == null || times.isEmpty()) {
            return null;
        }
        Set<Integer> timeKeys = times.keySet();
        for (Integer timeKey : timeKeys) {
            builder.append(timeKey).append(",").append(times.get(timeKey)).append("|");
        }
        builder.append("!");
        Map<String, Integer> types = this.tokenTypeMetrics.get(toKey);
        if (types == null) {
            return builder.toString();
        }
        Set<String> typeKeys = types.keySet();
        for (String typeKey : typeKeys) {
            builder.append(typeKey).append(",").append(types.get(typeKey)).append("|");
        }
        return builder.toString();
    }

    public void rmvTokenStatistics(String resource, long time) {
        String toKey = resource + "_" + time;
        if (!this.tokenTimeMetrics.isEmpty()) {
            this.tokenTimeMetrics.remove(toKey);
        }
        if (!this.tokenTypeMetrics.isEmpty()) {
            this.tokenTypeMetrics.remove(toKey);
        }
    }
}

