/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.metrics;

import com.alibaba.csp.sentinel.cluster.TokenResult;
import com.alibaba.csp.sentinel.cluster.TokenResultStatus;
import com.alibaba.csp.sentinel.cluster.metrics.ClusterMetric;
import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.node.metric.MetricWriter;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.util.TimeUtil;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ClusterMetricManager {
    private static volatile ClusterMetricManager clusterMetricManager;
    private static final String TOKEN_FILE = "token_metrics.log";
    private final MetricWriter metricWriter = new MetricWriter(SentinelConfig.singleMetricFileSize(), SentinelConfig.totalMetricFileCount());
    private static final int KEEP_ALIVE_TIME = 120000;
    private static final int QUEUE_SIZE = 100000;
    private final ExecutorService fetchService;
    private final ExecutorService logService;
    private final ThreadLocal<SimpleDateFormat> commonDateFormatThreadLocal = new ThreadLocal<SimpleDateFormat>(){

        @Override
        public SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };

    private ClusterMetricManager() {
        this.fetchService = new ThreadPoolExecutor(1, 1, 120000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(100000), new NamedThreadFactory("sentinel-cluster-metrics-record-task", true), new ThreadPoolExecutor.DiscardOldestPolicy());
        this.logService = new ThreadPoolExecutor(1, 1, 120000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(100000), new NamedThreadFactory("sentinel-cluster-metrics-log-task", true), new ThreadPoolExecutor.DiscardOldestPolicy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClusterMetricManager getInstance() {
        if (clusterMetricManager != null) return clusterMetricManager;
        Class<ClusterMetricManager> clazz = ClusterMetricManager.class;
        synchronized (ClusterMetricManager.class) {
            if (clusterMetricManager != null) return clusterMetricManager;
            clusterMetricManager = new ClusterMetricManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return clusterMetricManager;
        }
    }

    public void tokenFlowRuleMetrics(FlowRule rule, TokenResult result, final int cost) {
        final String resource = rule.getResource();
        long time = TimeUtil.currentTimeMillis();
        time -= time % 1000L;
        final long finalTime = time;
        final int status = result.getStatus();
        final String type = TokenResultStatus.toStatisticString(status);
        this.fetchService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ClusterMetric.getInstance().tokenStatusMetrics(resource, finalTime, type);
                    if (status == 0) {
                        ClusterMetric.getInstance().tokenTimeMetrics(resource, finalTime, cost);
                    }
                }
                catch (Throwable e) {
                    RecordLog.warn("[STATIC-CLUSTER-METRICS] failed, {}, {}, {}, {} ", resource, finalTime, type, cost, e);
                }
            }
        });
    }

    public String getTokenStatistics(final String resource, final long time) {
        final long finalTime = time - time % 1000L;
        final String pre = ClusterMetric.getInstance().getTokenStatistics(resource, finalTime);
        if (pre == null) {
            return null;
        }
        this.logService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String dateStr = ((SimpleDateFormat)ClusterMetricManager.this.commonDateFormatThreadLocal.get()).format(new Date(time));
                    ClusterMetricManager.this.metricWriter.commonWrite(Collections.singletonList(dateStr + "!" + resource + "!" + pre), ClusterMetricManager.TOKEN_FILE);
                    ClusterMetric.getInstance().rmvTokenStatistics(resource, finalTime);
                }
                catch (Throwable e) {
                    RecordLog.warn("[ClusterMetricManager] Failed to write token metrics on disk ", e);
                }
            }
        });
        return resource + "!" + time + "!" + pre;
    }
}

