/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.command;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Clock;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.IMetricManager;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Metric;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricFilter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricManager;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricName;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.CollectLevel;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.config.MetricsCollectPeriodConfig;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.integrate.ConfigFields;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.integrate.LoggerProvider;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.integrate.MetricsIntegrateUtils;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.BinAppender;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.StructMetricManagerReporter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.file.JsonMetricFormat;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.file.RollingFileAppender;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.server.MetricsMemoryCache;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.server.MetricsOnDisk;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.server.MetricsSearchService;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.status.LogDescriptionManager;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class AliMetricsBootstrap {
    private static IMetricManager metricManager = MetricManager.getIMetricManager();
    private static final MetricFilter metaMetricsFilter = new MetricFilter(){

        @Override
        public boolean matches(MetricName name, Metric metric) {
            return !name.getKey().startsWith("middleware.metrics.cache");
        }
    };
    private static final String logRootPath = "logs/metrics/bin";
    private static final String metricsLogName = "metrics/metrics.log";

    public static void init() {
        String agwInnerFlag = "2";
        if ("2".equals(System.getProperty("ahas.agw.type"))) {
            return;
        }
        AliMetricsBootstrap.init(System.getProperty(ConfigFields.CONFIG_FILE_NAME));
    }

    private static void initDatasOnDisk() {
        String agwInnerFlag = "2";
        if ("2".equals(System.getProperty("ahas.agw.type"))) {
            return;
        }
        LogDescriptionManager logDescriptionManager = new LogDescriptionManager(logRootPath);
        MetricsMemoryCache cache = new MetricsMemoryCache(60, logDescriptionManager);
        MetricsOnDisk metricsOnDisk = new MetricsOnDisk(logRootPath);
        BinAppender binAppender = new BinAppender(System.currentTimeMillis(), logRootPath, new MetricsCollectPeriodConfig(), logDescriptionManager, cache, 5, 5);
        binAppender.initWithoutCheckThread();
        RollingFileAppender fileAppender = RollingFileAppender.builder().name(metricsLogName).build();
        StructMetricManagerReporter reporter = new StructMetricManagerReporter(metricManager, binAppender, fileAppender, Clock.defaultClock(), TimeUnit.SECONDS, TimeUnit.SECONDS, TimeUnit.SECONDS, metaMetricsFilter, new MetricsCollectPeriodConfig(), new HashMap<String, String>(), new JsonMetricFormat(), CollectLevel.CLASSIFIER);
        reporter.setWriteMetricToFile(true);
        reporter.start(5L, TimeUnit.SECONDS);
        MetricsSearchService.build(cache, metricsOnDisk, logDescriptionManager);
    }

    private static void disableUselessMetrics(Properties config) {
        config.setProperty("com.alibaba.csp.ahas.shaded.com.alibaba.metrics.druid.enable", "false");
        config.setProperty("com.alibaba.csp.ahas.shaded.com.alibaba.metrics.tomcat.http.enable", "false");
        config.setProperty("com.alibaba.csp.ahas.shaded.com.alibaba.metrics.tomcat.thread.enable", "false");
        config.setProperty("com.alibaba.csp.ahas.shaded.com.alibaba.metrics.nginx.enable", "false");
    }

    public static void init(String configFile) {
        LoggerProvider.initLogger();
        Properties config = MetricsIntegrateUtils.parsePropertiesFromFile(configFile);
        if (configFile != null) {
            config.setProperty(ConfigFields.CONFIG_FILE_NAME, configFile);
        }
        AliMetricsBootstrap.disableUselessMetrics(config);
        AliMetricsBootstrap.initDatasOnDisk();
        MetricsIntegrateUtils.registerAllMetrics(config);
    }
}

