/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.command;

import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.HashMap;
import java.util.Map;

public class CommandRequest {
    private final Map<String, String> metadata = new HashMap<String, String>();
    private final Map<String, String> parameters = new HashMap<String, String>();
    private byte[] body;

    public byte[] getBody() {
        return this.body;
    }

    public CommandRequest setBody(byte[] body) {
        this.body = body;
        return this;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getParam(String key) {
        return this.parameters.get(key);
    }

    public String getParam(String key, String defaultValue) {
        String value = this.parameters.get(key);
        return StringUtil.isBlank(value) ? defaultValue : value;
    }

    public CommandRequest addParam(String key, String value) {
        if (StringUtil.isBlank(key)) {
            throw new IllegalArgumentException("Parameter key cannot be empty");
        }
        this.parameters.put(key, value);
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public CommandRequest addMetadata(String key, String value) {
        if (StringUtil.isBlank(key)) {
            throw new IllegalArgumentException("Metadata key cannot be empty");
        }
        this.metadata.put(key, value);
        return this;
    }
}

