/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.command.handler;

import com.alibaba.csp.ahas.shaded.org.apache.commons.exec.CommandLine;
import com.alibaba.csp.ahas.shaded.org.apache.commons.exec.DefaultExecutor;
import com.alibaba.csp.ahas.shaded.org.apache.commons.io.FileUtils;
import com.alibaba.csp.ahas.shaded.org.apache.commons.io.IOUtils;
import com.alibaba.csp.ahas.shaded.org.apache.commons.io.filefilter.AgeFileFilter;
import com.alibaba.csp.ahas.shaded.org.apache.commons.lang.StringUtils;
import com.alibaba.csp.ahas.shaded.org.apache.commons.lang.time.DateUtils;
import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.CommandRequest;
import com.alibaba.csp.sentinel.command.CommandResponse;
import com.alibaba.csp.sentinel.command.annotation.CommandMapping;
import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.csp.sentinel.log.RecordLog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@CommandMapping(name="executeShellCommand", desc="execute shell command")
public class ExecuteShellCommandHandler
implements CommandHandler<String> {
    public static final String USER_HOME = System.getProperty("user.home");
    private static final String SCRIPT_DIR = USER_HOME + "/temp";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private ExecutorService executorService = this.createExecutorService();

    public ExecutorService createExecutorService() {
        return new ThreadPoolExecutor(4, 9, 1L, TimeUnit.HOURS, new ArrayBlockingQueue<Runnable>(2000), new NamedThreadFactory("execute-shell-command-pool", true), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    @Override
    public CommandResponse<String> handle(CommandRequest request) {
        File script;
        String taskId = request.getParam("taskId");
        String command = request.getParam("command");
        command = StringUtils.replace(command, "{user.temp}", SCRIPT_DIR);
        try {
            script = this.createTempScript(taskId, command);
            if (script == null) {
                return CommandResponse.ofFailure(new IllegalStateException("\u521b\u5efa\u811a\u672c\u5931\u8d25"));
            }
        }
        catch (IOException e) {
            RecordLog.error("[ExecuteShellCommandHandler] Execute shell command error", e);
            return CommandResponse.ofFailure(e, "\u521b\u5efa\u811a\u672c\u5931\u8d25");
        }
        final DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(new File(USER_HOME));
        final CommandLine commandLine = CommandLine.parse("sh " + script.getAbsolutePath());
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    executor.execute(commandLine);
                }
                catch (Exception e) {
                    RecordLog.error("[ExecuteShellCommandHandler] Execute shell command error", e);
                }
                finally {
                    ExecuteShellCommandHandler.this.clearTempScript();
                }
            }
        });
        return CommandResponse.ofSuccess("success");
    }

    private void makeDirs(File file) {
        if (file == null) {
            return;
        }
        File parent = file.getParentFile();
        if (parent == null) {
            return;
        }
        if (parent.exists()) {
            return;
        }
        parent.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createTempScript(String taskId, String command) throws IOException {
        File file = new File(SCRIPT_DIR + "/" + taskId + "_" + System.currentTimeMillis() + ".sh");
        FileOutputStream outputStream = null;
        try {
            this.makeDirs(file);
            outputStream = FileUtils.openOutputStream(file);
            IOUtils.writeLines(Arrays.asList("#!/bin/bash", command), LINE_SEPARATOR, (OutputStream)outputStream, StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(outputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(outputStream);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    private void clearTempScript() {
        try {
            File dir = new File(SCRIPT_DIR);
            Date date = DateUtils.addDays(new Date(), -7);
            AgeFileFilter fileFilter = new AgeFileFilter(date, true);
            File[] files = dir.listFiles(fileFilter);
            if (files == null) {
                return;
            }
            for (File file : files) {
                if (!file.getName().endsWith(".sh")) continue;
                FileUtils.deleteQuietly(file);
            }
        }
        catch (Throwable e) {
            RecordLog.warn("[ExecuteShellCommandHandler] Failed to clearTempScript: " + e.getMessage(), e);
        }
    }
}

