/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.command.handler;

import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.JSON;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientConfigManager;
import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.CommandRequest;
import com.alibaba.csp.sentinel.command.CommandResponse;
import com.alibaba.csp.sentinel.command.annotation.CommandMapping;
import com.alibaba.csp.sentinel.command.entity.ClusterClientStateEntity;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.net.URLDecoder;

@CommandMapping(name="cluster/client/modifyConfig", desc="modify cluster client config")
public class ModifyClusterClientConfigHandler
implements CommandHandler<String> {
    @Override
    public CommandResponse<String> handle(CommandRequest request) {
        String data = request.getParam("data");
        if (StringUtil.isBlank(data)) {
            return CommandResponse.ofFailure(new IllegalArgumentException("empty data"));
        }
        try {
            data = URLDecoder.decode(data, "utf-8");
            RecordLog.info("[ModifyClusterClientConfigHandler] Receiving cluster client config: " + data, new Object[0]);
            ClusterClientStateEntity entity = JSON.parseObject(data, ClusterClientStateEntity.class);
            ClusterClientConfigManager.applyNewConfig(entity.toClientConfig());
            ClusterClientConfigManager.applyNewAssignConfig(entity.toAssignConfig());
            return CommandResponse.ofSuccess("success");
        }
        catch (Exception e) {
            RecordLog.warn("[ModifyClusterClientConfigHandler] Decode client cluster config error", e);
            return CommandResponse.ofFailure(e, "decode client cluster config error");
        }
    }
}

