/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.command.handler;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.ClusterHistogram;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Compass;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Counter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.FastCompass;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Gauge;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Histogram;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.IMetricManager;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Meter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricFilter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricManager;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricName;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricRegistry;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Timer;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.CollectLevel;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.MetricObject;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.MetricsCollector;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.MetricsCollectorFactory;
import com.alibaba.csp.ahas.shaded.org.apache.commons.lang.StringUtils;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.cluster.metrics.ClusterMetricManager;
import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.CommandRequest;
import com.alibaba.csp.sentinel.command.CommandResponse;
import com.alibaba.csp.sentinel.command.annotation.CommandMapping;
import com.alibaba.csp.sentinel.command.system.SystemMetricsManager;
import com.alibaba.csp.sentinel.command.system.reader.ISystemMetricsReader;
import com.alibaba.csp.sentinel.command.system.reader.SystemMetricsReaderFactory;
import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.metric.log.block.BlockRuleTriggerMetricItem;
import com.alibaba.csp.sentinel.node.metric.MetricNode;
import com.alibaba.csp.sentinel.node.metric.MetricSearcher;
import com.alibaba.csp.sentinel.node.metric.MetricWriter;
import com.alibaba.csp.sentinel.slots.block.flow.exception.ExceptionMetricsManager;
import com.alibaba.csp.sentinel.slots.block.flow.statuscode.StatusCodeMetricManager;
import com.alibaba.csp.sentinel.slots.statistic.metric.param.ParamsMetricManager;
import com.alibaba.csp.sentinel.util.ContainerUtil;
import com.alibaba.csp.sentinel.util.PidUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.csp.sentinel.util.TimeUtil;
import com.alibaba.csp.sentinel.util.function.Function;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;

@CommandMapping(name="metric", desc="get and aggregate metrics, accept param: startTime={startTime}&endTime={endTime}&maxLines={maxLines}&identify={resourceName}")
public class SendMetricCommandHandler
implements CommandHandler<String> {
    private MetricSearcher searcher;
    private MetricSearcher rulePasserSearcher;
    private final Object lock = new Object();
    private final Object lock1 = new Object();
    private static IMetricManager metricsManager = MetricManager.getIMetricManager();
    private static final long DEFAULT_METRICS_INTERVAL_MS = 10000L;
    private static final double rateFactor = TimeUnit.SECONDS.toSeconds(1L);
    private static final double durationFactor = 1.0 / (double)TimeUnit.MILLISECONDS.toNanos(1L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandResponse<String> handle(CommandRequest request) {
        List<BlockRuleTriggerMetricItem> ruleTriggerMetricList;
        List<MetricNode> list;
        Object object;
        if (this.searcher == null) {
            object = this.lock;
            synchronized (object) {
                String appName = SentinelConfig.getAppName();
                if (appName == null) {
                    appName = "";
                }
                if (this.searcher == null) {
                    this.searcher = new MetricSearcher(MetricWriter.METRIC_BASE_DIR, MetricWriter.formMetricFileName(appName, PidUtil.getPid()));
                }
            }
        }
        if (this.rulePasserSearcher == null) {
            object = this.lock1;
            synchronized (object) {
                if (this.rulePasserSearcher == null) {
                    this.rulePasserSearcher = new MetricSearcher(MetricWriter.METRIC_BASE_DIR, MetricWriter.formSentinelBlockFileName(PidUtil.getPid()));
                }
            }
        }
        String startTimeStr = request.getParam("startTime");
        String endTimeStr = request.getParam("endTime");
        String identity = request.getParam("identity");
        String metrics = request.getParam("metrics");
        String metricsGroup = request.getParam("metricsGroup");
        String newMetrics = request.getParam("newMetrics");
        long endTime = -1L;
        long startTime = 1L;
        if (com.alibaba.csp.ahas.shaded.com.alibaba.metrics.StringUtils.isNotBlank("startTime") && com.alibaba.csp.ahas.shaded.com.alibaba.metrics.StringUtils.isNotBlank("endTime")) {
            startTime = Long.parseLong(startTimeStr);
            endTime = Long.parseLong(endTimeStr);
        } else {
            endTime = System.currentTimeMillis();
            startTime = endTime - 10000L;
        }
        try {
            list = this.searcher.findByTimeAndResource(startTime, endTime, identity, new Function<String, MetricNode>(){

                @Override
                public MetricNode apply(String str) {
                    return MetricNode.fromFatString(str);
                }
            });
            ruleTriggerMetricList = this.rulePasserSearcher.findByTimeAndResource(startTime, endTime, identity, new Function<String, BlockRuleTriggerMetricItem>(){

                @Override
                public BlockRuleTriggerMetricItem apply(String str) {
                    return BlockRuleTriggerMetricItem.fromFatString(str);
                }
            });
        }
        catch (Exception ex) {
            return CommandResponse.ofFailure(new RuntimeException("Error when retrieving metrics", ex));
        }
        if (list == null) {
            list = new ArrayList<MetricNode>(0);
        }
        if (ruleTriggerMetricList == null) {
            ruleTriggerMetricList = new ArrayList<BlockRuleTriggerMetricItem>(0);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.readLineFromFile("metrics_template_version")).append("\n");
        long time = TimeUtil.currentTimeMillis();
        time -= time % 1000L;
        if (StringUtil.isBlank(identity)) {
            this.addDubboMetrics(list, metrics, metricsGroup, time);
        }
        sb.append(list.size()).append("\n");
        StringBuilder statusBuilder = new StringBuilder();
        int index = 0;
        int num = 0;
        for (MetricNode metricNode : list) {
            sb.append(metricNode.toThinString()).append("\n");
            String status = StatusCodeMetricManager.getInstance().getStatisticStatusCode(metricNode.getResource(), metricNode.getTimestamp());
            if (!StringUtils.isEmpty(status)) {
                statusBuilder.append(index).append(",").append(status).append("\n");
                ++num;
            }
            ++index;
        }
        sb.append(num).append("\n");
        if (num > 0) {
            sb.append((CharSequence)statusBuilder);
        }
        List<String> exceptions = ExceptionMetricsManager.getInstance().getExceptions();
        sb.append(exceptions.size()).append("\n");
        if (exceptions.size() > 0) {
            for (String exception : exceptions) {
                sb.append(exception).append("\n");
            }
        }
        sb.append(ruleTriggerMetricList.size()).append("\n");
        for (BlockRuleTriggerMetricItem ruleTriggerMetric : ruleTriggerMetricList) {
            sb.append(ruleTriggerMetric.toThinString()).append("\n");
        }
        StringBuilder stringBuilder = new StringBuilder();
        int tokenStatNum = 0;
        for (MetricNode node : list) {
            String tokenStatistics = ClusterMetricManager.getInstance().getTokenStatistics(node.getResource(), node.getTimestamp());
            if (tokenStatistics == null) continue;
            stringBuilder.append(tokenStatistics).append("\n");
            ++tokenStatNum;
        }
        sb.append(tokenStatNum).append("\n");
        if (tokenStatNum > 0) {
            sb.append((CharSequence)stringBuilder);
        }
        StringBuilder paramBuilder = new StringBuilder();
        List<String> hots = ParamsMetricManager.getInstance().getHotParamStatistics();
        for (String hot : hots) {
            paramBuilder.append(hot).append("\n");
        }
        int paramNum = hots.size();
        sb.append(paramNum).append("\n");
        if (paramNum > 0) {
            sb.append((CharSequence)paramBuilder);
        }
        if (StringUtil.isBlank(identity)) {
            String systemMetrics = SystemMetricsManager.getInstance().getSystemIndexes(SendMetricCommandHandler.getMetricsParams(newMetrics), time);
            sb.append(systemMetrics);
        }
        return CommandResponse.ofSuccess(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLineFromFile(String filePath) {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(filePath);
        if (inputStream == null) {
            return "#_1_9_0";
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(inputStream));
            String string = "#_" + reader.readLine();
            return string;
        }
        catch (Exception ex) {
            RecordLog.warn("[SendMetricCommandHandler] WARN: Failed to get metrics template version ", ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    RecordLog.warn("[SendMetricCommandHandler] WARN: Failed to close reader ", e);
                }
            }
            try {
                inputStream.close();
            }
            catch (Exception e) {
                RecordLog.warn("[ContainerSystemMetricReader] Failed to close inputStream " + filePath, e);
            }
        }
        return "#_1_9_0";
    }

    private void addDubboMetrics(List<MetricNode> list, String metricName, String metricsGroup, long time) {
        List<String> groups = SendMetricCommandHandler.getMetricsParams(metricsGroup);
        if (groups == null || groups.size() < 1) {
            groups = metricsManager.listMetricGroups();
        }
        if (ContainerUtil.isRunningInContainer()) {
            ISystemMetricsReader iSystemMetricsReader = SystemMetricsReaderFactory.getInstance().getSystemMetricsReader();
            MetricNode cpuNode = new MetricNode();
            cpuNode.setPassQps((long)(iSystemMetricsReader.getMetricWithId("system", "system.cpu.user") * 10000.0));
            cpuNode.setTimestamp(time);
            cpuNode.setResource("system.cpu.user");
            cpuNode.setClassification(9999);
            cpuNode.setTrafficType(EntryType.INTERNAL);
            list.add(cpuNode);
            MetricNode loadNode = new MetricNode();
            loadNode.setPassQps(0L);
            loadNode.setTimestamp(time);
            loadNode.setResource("system.load.1min");
            loadNode.setClassification(9999);
            loadNode.setTrafficType(EntryType.INTERNAL);
            list.add(loadNode);
            return;
        }
        List<String> metricNames = SendMetricCommandHandler.getMetricsParams(metricName);
        boolean userMetricFilter = metricNames.size() > 0;
        for (String group : groups) {
            try {
                MetricRegistry registry = metricsManager.getMetricRegistryByGroup(group);
                List<MetricObject> metrics = this.getDubboMetrics(registry, time);
                if (metrics == null | metrics.size() < 1) continue;
                for (MetricObject metric : metrics) {
                    if (!userMetricFilter) {
                        list.add(this.dubboMetricToNode(metric));
                        continue;
                    }
                    if (!userMetricFilter || !metricNames.contains(metric.getMetric())) continue;
                    list.add(this.dubboMetricToNode(metric));
                }
            }
            catch (Throwable e) {
                RecordLog.warn("[SendMetricCommandHandler] WARN: Failed to get metrics, group=" + group, e);
            }
        }
    }

    private MetricNode dubboMetricToNode(MetricObject metric) {
        MetricNode node = new MetricNode();
        Number value = (Number)metric.getValue();
        node.setPassQps((long)(value.doubleValue() * 10000.0));
        node.setTimestamp(metric.getTimestamp());
        node.setResource(metric.getMetric());
        node.setClassification(9999);
        node.setTrafficType(EntryType.INTERNAL);
        return node;
    }

    private List<MetricObject> getDubboMetrics(MetricRegistry registry, long ts) {
        return this.getDubboMetrics(registry, null, ts);
    }

    private List<MetricObject> getDubboMetrics(MetricRegistry registry, MetricFilter filter, long ts) {
        MetricsCollector collector = MetricsCollectorFactory.createNew(CollectLevel.NORMAL, rateFactor, durationFactor, filter);
        SortedMap<MetricName, Gauge> gauges = filter == null ? registry.getGauges() : registry.getGauges(filter);
        for (Map.Entry<MetricName, Gauge> entry : gauges.entrySet()) {
            collector.collect(entry.getKey(), entry.getValue(), ts);
        }
        SortedMap<MetricName, Counter> counters = filter == null ? registry.getCounters() : registry.getCounters(filter);
        for (Map.Entry<MetricName, Counter> entry : counters.entrySet()) {
            collector.collect(entry.getKey(), entry.getValue(), ts);
        }
        SortedMap<MetricName, Meter> sortedMap = filter == null ? registry.getMeters() : registry.getMeters(filter);
        for (Map.Entry<MetricName, Meter> entry : sortedMap.entrySet()) {
            collector.collect(entry.getKey(), entry.getValue(), ts);
        }
        SortedMap<MetricName, Histogram> sortedMap2 = filter == null ? registry.getHistograms() : registry.getHistograms(filter);
        for (Map.Entry<MetricName, Histogram> entry : sortedMap2.entrySet()) {
            collector.collect(entry.getKey(), entry.getValue(), ts);
        }
        SortedMap<MetricName, Timer> sortedMap3 = filter == null ? registry.getTimers() : registry.getTimers(filter);
        for (Map.Entry<MetricName, Timer> entry : sortedMap3.entrySet()) {
            collector.collect(entry.getKey(), entry.getValue(), ts);
        }
        SortedMap<MetricName, Compass> sortedMap4 = filter == null ? registry.getCompasses() : registry.getCompasses(filter);
        for (Map.Entry<MetricName, Compass> entry : sortedMap4.entrySet()) {
            collector.collect(entry.getKey(), entry.getValue(), ts);
        }
        SortedMap<MetricName, FastCompass> sortedMap5 = filter == null ? registry.getFastCompasses() : registry.getFastCompasses(filter);
        for (Map.Entry<MetricName, FastCompass> entry : sortedMap5.entrySet()) {
            collector.collect(entry.getKey(), entry.getValue(), ts);
        }
        SortedMap<MetricName, ClusterHistogram> sortedMap6 = filter == null ? registry.getClusterHistograms() : registry.getClusterHistograms(filter);
        for (Map.Entry<MetricName, ClusterHistogram> entry : sortedMap6.entrySet()) {
            collector.collect(entry.getKey(), entry.getValue(), ts);
        }
        return collector.build();
    }

    private static List<String> getMetricsParams(String origin) {
        if (com.alibaba.csp.ahas.shaded.com.alibaba.metrics.StringUtils.isBlank(origin)) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> params = new ArrayList<String>();
        for (String group : origin.split(",")) {
            params.add(group);
        }
        return params;
    }
}

